/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcDefaultWebResourceToHttp.java,v 1.6 2006/12/07 04:55:30 aslom Exp $ */
package org.gpel.client.http;

import java.net.URI;
import org.gpel.client.GcAtomResource;
import org.gpel.client.GcException;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;

public class GcDefaultWebResourceToHttp implements GcWebResourceToHttp {
    
    public static GcDefaultWebResourceToHttp getInstance() {
        return new GcDefaultWebResourceToHttp();
    }
    
    public GcHttpRequest transformResourceToHttpRequest(GcHttpRequest.Method httpMethod,
                                                 URI loc,
                                                 GcWebResource resource) throws GcException {
        GcHttpRequest req;
//        if (resource instanceof GcXmlWebResource) {
//            XmlElement el = ((GcXmlWebResource)resource).xml();
//            req = new GcHttpRequest(httpMethod, loc, GcUtil.CONTENT_TYPE_ATOM, el);
//        } else if (resource instanceof GcTextWebResource) {
//            String text = ((GcTextWebResource)resource).text();
//            req = new GcHttpRequest(httpMethod, loc, GcUtil.CONTENT_TYPE_ATOM, text);
//        } else if (resource instanceof GcBinaryWebResource) {
//            byte[] binary = ((GcBinaryWebResource)resource).binary();
//            req = new GcHttpRequest(httpMethod, loc, GcUtil.CONTENT_TYPE_ATOM, binary);
//        } else {
//            throw new GcException("unsupproted type of web resource " + resource.getClass());
//        }
        req = new GcHttpRequest(httpMethod, loc, GcUtil.CONTENT_TYPE_ATOM,
                                ((GcAtomResource)resource).xml());
        return req;
        
    }
}

