/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelAssign.java,v 1.6 2008/02/26 01:39:24 cherath Exp $
 */
package org.gpel.model;

import java.util.Iterator;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.XmlValidationException;

public class GpelAssign extends GpelActivity {
    public static final String TYPE_NAME = "assign";

    public GpelAssign(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelAssign(XmlNamespace NS, GpelAssignCopy requiredCopyOp) {
        super(NS, TYPE_NAME);
        addCopy(requiredCopyOp);
    }

    public GpelAssign(XmlNamespace NS, Iterable<GpelAssignCopy> copyOps) {
        super(NS, TYPE_NAME);
        boolean empty = true;
        for (GpelAssignCopy copyOp: copyOps) {
            empty = false;
            addCopy(copyOp);
        }
        if (empty) {
            throw new GpelModelValidationException(
                "at least one copy is required inside assign");
        }
    }

    public void addCopy(GpelAssignCopy requiredCopyOp) {
        if (requiredCopyOp == null) throw new IllegalArgumentException();
        xml().addElement(requiredCopyOp.xml());
    }

    public Iterable<GpelAssignCopy> copyOperations() {
        //return xml().elements(xml().getNamespace(), GpelVariable.TYPE_NAME);
        //final Iterator<XmlElement> elContent = xml().requiredElementContent().iterator();
        final Iterator<XmlElement> elContent =
            xml().elements(xml().getNamespace(), GpelAssignCopy.TYPE_NAME).iterator();
        Iterable<GpelAssignCopy> giterable = new Iterable<GpelAssignCopy>() {
            public Iterator<GpelAssignCopy> iterator() {
                return new Iterator<GpelAssignCopy>() {
                    public boolean hasNext() {
                        return elContent.hasNext();
                    }

                    public GpelAssignCopy next() {
                        //GpelActivity activity;
                        XmlElement el = elContent.next();
                        GpelAssignCopy activity = el.viewAs(GpelAssignCopy.class);
                        return activity;
                    }


                    public void remove() {
                        elContent.remove();
                    }

                };
            }
        };
        return giterable;
    }

//    public void validateGpelModel() throws GpelModelValidationException {
    public void xmlValidate() throws XmlValidationException {
        checkNamespaceAndName();
        //super.validateGpelModel();
        GpelAssignCopy atLeastOneCopyOp = copyOperations().iterator().next();
        if(atLeastOneCopyOp == null) {
            throw new XmlValidationException("at least one copy is required inside "+xmlString());
        }
        for(GpelAssignCopy op : copyOperations()) {
            op.xmlValidate();
        }
    }

}

/*
* Indiana University Extreme! Lab Software License, Version 1.2
*
* Copyright (c) 2004-2005 The Trustees of Indiana University.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
* 1) All redistributions of source code must retain the above
*    copyright notice, the list of authors in the original source
*    code, this list of conditions and the disclaimer listed in this
*    license;
*
* 2) All redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the disclaimer
*    listed in this license in the documentation and/or other
*    materials provided with the distribution;
*
* 3) Any documentation included with all redistributions must include
*    the following acknowledgement:
*
*      "This product includes software developed by the Indiana
*      University Extreme! Lab.  For further information please visit
*      http://www.extreme.indiana.edu/"
*
*    Alternatively, this acknowledgment may appear in the software
*    itself, and wherever such third-party acknowledgments normally
*    appear.
*
* 4) The name "Indiana University" or "Indiana University
*    Extreme! Lab" shall not be used to endorse or promote
*    products derived from this software without prior written
*    permission from Indiana University.  For written permission,
*    please contact http://www.extreme.indiana.edu/.
*
* 5) Products derived from this software may not use "Indiana
*    University" name nor may "Indiana University" appear in their name,
*    without prior written permission of the Indiana University.
*
* Indiana University provides no reassurances that the source code
* provided does not infringe the patent or any other intellectual
* property rights of any other entity.  Indiana University disclaims any
* liability to any recipient for claims brought by any other entity
* based on infringement of intellectual property rights or otherwise.
*
* LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
* NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
* UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
* SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
* OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
* SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
* DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
* RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
* AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
* SOFTWARE.
*/


