/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelAssignCopyFrom.java,v 1.6 2008/02/26 01:39:24 cherath Exp $
 */
package org.gpel.model;

import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.XmlValidationException;

public class GpelAssignCopyFrom extends GpelAssignCopyParams {
    public static final String TYPE_NAME = "from";
    public static final String LITERAL_EL = "literal";

    public GpelAssignCopyFrom(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelAssignCopyFrom(XmlNamespace NS) {
        super(NS, TYPE_NAME);
    }

    public GpelAssignCopyFrom setVariable(String variable) {
        super.setVariable(variable);
        return this;
    }

    public GpelAssignCopyFrom setPart(String part) {
        super.setPart(part);
        return this;
    }

    public GpelAssignCopyFrom setQuery(String query) {
        super.setQuery(query);
        return this;
    }

    public GpelAssignCopyParams setPartnerLink(String partnerLinkName) {
        super.setPartnerLink(partnerLinkName);
        return this;
    }
    public GpelAssignCopyFrom setEndpointReference(String endpointReferenceName) {
        super.setEndpointReference(endpointReferenceName);
        return this;
    }

    public XmlElement getLiteral() {
        XmlNamespace myNs = xml().getNamespace();
        XmlElement el = xml().element(myNs, LITERAL_EL);
        return el;
    }

    public GpelAssignCopyFrom  setLiteral(XmlElement literalContainerElement) {
        XmlNamespace myNs = xml().getNamespace();
//        if(getPart() != null) setPart(null);
//        if(getQuery() != null) setQuery(null);
//        if(getVariable() != null) setVariable(null);
        xml().removeAllChildren();
        if(literalContainerElement == null) return this; //removed <literal/> and done
        if(literalContainerElement.getParent() != null) throw new IllegalArgumentException("literal must have no parent");
        literalContainerElement.setName(LITERAL_EL);
        literalContainerElement.setNamespace(myNs);
        xml().addElement(literalContainerElement);
        return this;
    }

    /**
     * Cleanup element content and attributes to make sure it valid syntax
     */
    public void resetElement() {
        xml().removeAllChildren();
        //XmlElement literalEl = xml().element(myNs, LITERAL_EL);
        //if(literalEl != null) xml().removeElement(literalEl);
        xml().removeAllAttributes();
    }

    public void xmlValidate() throws XmlValidationException {
        checkNamespaceAndName();
        XmlElement literal = getLiteral();
        String var = getVariable();
        String part = getPart();
        String query = getQuery();
        String plink = getPartnerLink();
        String eref = getEndpointReference();
        // very rudimentary syntax checks (TODO: BPEL 2.0)
        if(literal != null) {
            if(var != null || part != null || query != null || plink != null || eref != null) {
                throw new XmlValidationException(
                        "literal can not be mixed with other attributes in "+xmlString());
            }
        } else {
            if(var == null && plink == null) {
                throw new XmlValidationException(
                        "either literal or variable or partner link needs to be set in "+xmlString());
            }
            if(plink != null && eref == null) {
                throw new XmlValidationException(
                        "both partner link and endpoint reference needs to be set in "+xmlString());
            }
        }
    }

}

/*
* Indiana University Extreme! Lab Software License, Version 1.2
*
* Copyright (c) 2004-2005 The Trustees of Indiana University.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
* 1) All redistributions of source code must retain the above
*    copyright notice, the list of authors in the original source
*    code, this list of conditions and the disclaimer listed in this
*    license;
*
* 2) All redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the disclaimer
*    listed in this license in the documentation and/or other
*    materials provided with the distribution;
*
* 3) Any documentation included with all redistributions must include
*    the following acknowledgement:
*
*      "This product includes software developed by the Indiana
*      University Extreme! Lab.  For further information please visit
*      http://www.extreme.indiana.edu/"
*
*    Alternatively, this acknowledgment may appear in the software
*    itself, and wherever such third-party acknowledgments normally
*    appear.
*
* 4) The name "Indiana University" or "Indiana University
*    Extreme! Lab" shall not be used to endorse or promote
*    products derived from this software without prior written
*    permission from Indiana University.  For written permission,
*    please contact http://www.extreme.indiana.edu/.
*
* 5) Products derived from this software may not use "Indiana
*    University" name nor may "Indiana University" appear in their name,
*    without prior written permission of the Indiana University.
*
* Indiana University provides no reassurances that the source code
* provided does not infringe the patent or any other intellectual
* property rights of any other entity.  Indiana University disclaims any
* liability to any recipient for claims brought by any other entity
* based on infringement of intellectual property rights or otherwise.
*
* LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
* NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
* UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
* SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
* OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
* SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
* DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
* RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
* AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
* SOFTWARE.
*/


