/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelForEach.java,v 1.3 2008/02/26 01:39:24 cherath Exp $
 */
package org.gpel.model;

import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

// <forEach counterName="BPELVariableName" parallel="yes|no" standard-attributes>
// standard-elements
// <startCounterValue expressionLanguage="anyURI"?>
// unsigned-integer-expression
// </startCounterValue>
// <finalCounterValue expressionLanguage="anyURI"?>
// unsigned-integer-expression
// </finalCounterValue>
// // <completionCondition>? <!-- not supported in this version -->
// // <branches expressionLanguage="anyURI"? successfulBranchesOnly="yes|no"?>
// // unsigned-integer-expression
// // </branches>
// </completionCondition>
// <scope ...>...</scope>
// </forEach>

public class GpelForEach extends GpelContainerActivityOfOne {
    public static final String TYPE_NAME = "forEach";

    public static final String COUNTER_NAME_ATTR = "counterName";

    public static final String PARALLEL_ATTR = "parallel";

    public static final String YES_PARALLEL = "yes";

    public static final String NO_PARALLEL = "no";

    // public static final enum YES_NO { yes, no } ; //use boolean?
    public static final String START_COUNTER_VALUE_EL = "startCounterValue";

    public static final String FINAL_COUNTER_VALUE_EL = "finalCounterValue";

    public GpelForEach(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelForEach(XmlNamespace NS, String counterName, String startCounterValue, String finalCounterValue,
            boolean isParallel, GpelScope scope) {
        super(NS, TYPE_NAME);
        if (counterName == null) throw new IllegalArgumentException();
        if (startCounterValue == null) throw new IllegalArgumentException();
        if (finalCounterValue == null) throw new IllegalArgumentException();
        xml().setAttributeValue(COUNTER_NAME_ATTR, counterName);
        xml().setAttributeValue(PARALLEL_ATTR, isParallel ? YES_PARALLEL : NO_PARALLEL);
        xml().addElement(xml().getNamespace(), START_COUNTER_VALUE_EL).setText(startCounterValue);
        xml().addElement(xml().getNamespace(), FINAL_COUNTER_VALUE_EL).setText(finalCounterValue);
        setActivity(scope);
    }

    public String getCounterName() {
        return xml().requiredAttributeValue(COUNTER_NAME_ATTR);
    }

    public String getStartCounterValue() {
        return xml().requiredElement(xml().getNamespace(), START_COUNTER_VALUE_EL).requiredText();
    }

    public String getFinalCounterValue() {
        return xml().requiredElement(xml().getNamespace(), FINAL_COUNTER_VALUE_EL).requiredText();
    }

    public boolean isParallel() {
        String val = xml().requiredAttributeValue(PARALLEL_ATTR);
        if (YES_PARALLEL.equals(val)) {
            return true;
        } else if (NO_PARALLEL.equals(val)) {
            return false;
        } else {
            throw new GpelModelException("Expected " + YES_PARALLEL + " or " + NO_PARALLEL
                    + " but got " + val + " in " + xmlString());
        }
    }
}

/*
 * Indiana University Extreme! Lab Software License, Version 1.2
 *
 * Copyright (c) 2004-2005 The Trustees of Indiana University. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 *
 * 1) All redistributions of source code must retain the above copyright notice, the list of authors
 * in the original source code, this list of conditions and the disclaimer listed in this license;
 *
 * 2) All redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the disclaimer listed in this license in the documentation and/or other materials
 * provided with the distribution;
 *
 * 3) Any documentation included with all redistributions must include the following
 * acknowledgement:
 *
 * "This product includes software developed by the Indiana University Extreme! Lab. For further
 * information please visit http://www.extreme.indiana.edu/"
 *
 * Alternatively, this acknowledgment may appear in the software itself, and wherever such
 * third-party acknowledgments normally appear.
 *
 * 4) The name "Indiana University" or "Indiana University Extreme! Lab" shall not be used to
 * endorse or promote products derived from this software without prior written permission from
 * Indiana University. For written permission, please contact http://www.extreme.indiana.edu/.
 *
 * 5) Products derived from this software may not use "Indiana University" name nor may "Indiana
 * University" appear in their name, without prior written permission of the Indiana University.
 *
 * Indiana University provides no reassurances that the source code provided does not infringe the
 * patent or any other intellectual property rights of any other entity. Indiana University
 * disclaims any liability to any recipient for claims brought by any other entity based on
 * infringement of intellectual property rights or otherwise.
 *
 * LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH NO WARRANTIES AS TO CAPABILITIES
 * OR ACCURACY ARE MADE. INDIANA UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
 * SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR OTHER PROPRIETARY RIGHTS.
 * INDIANA UNIVERSITY MAKES NO WARRANTIES THAT SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN
 * HORSES", "TRAP DOORS", "WORMS", OR OTHER HARMFUL CODE. LICENSEE ASSUMES THE ENTIRE RISK AS TO THE
 * PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS, AND TO THE PERFORMANCE AND VALIDITY OF
 * INFORMATION GENERATED USING SOFTWARE.
 */

