/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelIf.java,v 1.4 2008/02/26 01:39:24 cherath Exp $
 */
package org.gpel.model;

import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

// <if standard-attributes>
// standard-elements
// <condition expressionLanguage="anyURI"?>bool-expr</condition>
// activity
// <elseif>*
// <condition expressionLanguage="anyURI"?>bool-expr</condition>
// activity
// </elseif>
// <else>?
// activity
// </else>
// </if>

public class GpelIf extends GpelContainerActivityOfOne {
    public static final String TYPE_NAME = "if";

    public GpelIf(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelIf(XmlNamespace NS, GpelCondition condition, GpelActivity activity) {
        super(NS, TYPE_NAME);
        // setCondition(condition);
        xml().addElement(condition.xml());
        setActivity(activity);
    }

    public void addActivity(GpelActivity activity) {
        GpelCondition condition = getCondition();
        if (condition == null) {
            throw new IllegalStateException("missing required condition " + xmlString());
        }
        // NOTE make sure activity is always inserted after condition (and
        // before elseif/else)
        // to make sure this happen we remove condition, activity, and anything
        // else and reinsert
        // super.addActivity(activity);
        if (getActivity(false) != null) {
            throw new IllegalStateException(
                    "this container can have only one activity that is already set " + xmlString());
        }
        // replaceElement
        // calling setActivity causes an infinite loop.
        // setActivity(activity);
        super.addActivity(activity);
    }

    public GpelIf setCondition(GpelCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException();
        }
        XmlElement oldConditionEl = xml().element(xml().getNamespace(), GpelCondition.TYPE_NAME);
        if (oldConditionEl != null) {
            // xml().removeChild(el);
            xml().replaceElement(condition.xml(), oldConditionEl); // maintain
                                                                    // position
        } else {
          throw new IllegalStateException("missing required condition "+xmlString());
        }
        return this;
    }

    /**
     * Condition is required (null is never returned)
     *
     * @return
     */
    public GpelCondition getCondition() {
        return xml().requiredElement(xml().getNamespace(), GpelCondition.TYPE_NAME).viewAs(
                GpelCondition.class);
    }

    /**
     * Else is optional (null MAY be returned)
     *
     * @return
     */
    public GpelElse getElse() {
        return xml().requiredElement(xml().getNamespace(), GpelElse.TYPE_NAME).viewAs(
                GpelElse.class);
    }

    public GpelIf setElse(GpelElse gpelElse) {
        XmlElement oldElseEl = xml().element(xml().getNamespace(), GpelElse.TYPE_NAME);
        if (gpelElse == null) {
            xml().removeChild(oldElseEl); // setting else to null removes it
        } else {
            if (oldElseEl != null) {
                xml().replaceElement(gpelElse.xml(), oldElseEl); // maintain position
            } else {
                xml().addElement(gpelElse.xml()); // add it as last one
            }
        }
        return this;

    }

    // private void reShuffleElements() {
    // // get condition, activity, elseif*, else* elements and make sure they
    // are in order
    // // copy children into list
    // // extract condition
    // }

}

/*
 * Indiana University Extreme! Lab Software License, Version 1.2
 *
 * Copyright (c) 2004-2005 The Trustees of Indiana University. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 *
 * 1) All redistributions of source code must retain the above copyright notice, the list of authors
 * in the original source code, this list of conditions and the disclaimer listed in this license;
 *
 * 2) All redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the disclaimer listed in this license in the documentation and/or other materials
 * provided with the distribution;
 *
 * 3) Any documentation included with all redistributions must include the following
 * acknowledgement:
 *
 * "This product includes software developed by the Indiana University Extreme! Lab. For further
 * information please visit http://www.extreme.indiana.edu/"
 *
 * Alternatively, this acknowledgment may appear in the software itself, and wherever such
 * third-party acknowledgments normally appear.
 *
 * 4) The name "Indiana University" or "Indiana University Extreme! Lab" shall not be used to
 * endorse or promote products derived from this software without prior written permission from
 * Indiana University. For written permission, please contact http://www.extreme.indiana.edu/.
 *
 * 5) Products derived from this software may not use "Indiana University" name nor may "Indiana
 * University" appear in their name, without prior written permission of the Indiana University.
 *
 * Indiana University provides no reassurances that the source code provided does not infringe the
 * patent or any other intellectual property rights of any other entity. Indiana University
 * disclaims any liability to any recipient for claims brought by any other entity based on
 * infringement of intellectual property rights or otherwise.
 *
 * LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH NO WARRANTIES AS TO CAPABILITIES
 * OR ACCURACY ARE MADE. INDIANA UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
 * SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR OTHER PROPRIETARY RIGHTS.
 * INDIANA UNIVERSITY MAKES NO WARRANTIES THAT SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN
 * HORSES", "TRAP DOORS", "WORMS", OR OTHER HARMFUL CODE. LICENSEE ASSUMES THE ENTIRE RISK AS TO THE
 * PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS, AND TO THE PERFORMANCE AND VALIDITY OF
 * INFORMATION GENERATED USING SOFTWARE.
 */

