/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelResolver.java,v 1.6 2006/12/07 04:55:31 aslom Exp $
 */
package org.gpel.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gpel.GpelConstants;
import org.gpel.logger.GLogger;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlInfosetBuilder;

/**
 * Manage GPEL processes loading and locating.
 *
 * @version $Revision: 1.6 $
 * @author <a href="http://www.extreme.indiana.edu/~aslom/">Aleksander Slominski</a>
 */
public class GpelResolver {
    private final static GLogger logger = GLogger.getLogger();
    private final static XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private final static GpelResolver instance = new GpelResolver();
    protected Map ns2Gpel = new HashMap();
    protected Map location2Gpel = new HashMap();
    
    GpelResolver() {
    }
    
    public static GpelResolver getInstance() throws GpelModelException {
        return instance;
    }
    
    
    public GpelProcess loadGpel(URI url)
    throws GpelModelException {
        return loadGpel(null, url, false);
    }
    
    public GpelProcess loadGpel(URI base, URI url)
    throws GpelModelException {
        return loadGpel(base, url, false);
    }
    
    public GpelProcess loadGpel(URI base, URI location, boolean useCache)
    throws GpelModelException {
        
        if (useCache) {
            Object hit = location2Gpel.get(location);
            if (hit != null) {
                return (GpelProcess) hit;
            }
        }
        
        GpelProcess process;
        URI uri;
        try {
            uri = base != null ? base.resolve(location) : location;
            XmlDocument doc;
//            if (uri.getScheme().equals("file"))  {
//                FileInputStream is = new FileInputStream(new File(uri));
//                ByteArrayOutputStream baos = new ByteArrayOutputStream();
//                int read;
//                byte[] barr = new byte[4*1024];
//                while((read = is.read(barr)) !=  -1) {
//                    baos.write(barr, 0, read);
//                }
//                String input = new String(baos.toByteArray(), "UTF-8");
//                System.err.println("input="+input);
//                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
//                doc = builder.parseInputStream(bais);
//            } else {
                URL url = uri.toURL();
                URLConnection conn = url.openConnection();
                doc = builder.parseInputStream(conn.getInputStream(),
                                               conn.getContentEncoding());
//            }
            process = new GpelProcess(doc.getDocumentElement());
        } catch (IOException e) {
            throw new GpelModelException("could not load GPEL from " + location, e);
        }
        location2Gpel.put(location, process);
        ns2Gpel.put(process.getTargetNamespace(), process);
        return process;
    }
    
    
    public GpelProcess loadGpel(Class referenceClassForLoading, String gpelLoc) {
        URI base = ((new File(".")).toURI());
        URI gpelLoclUri;
        try {
            gpelLoclUri = new URI(gpelLoc);
        } catch (URISyntaxException e) {
            throw new GpelModelException(
                "location of WSDL must be correct URI, could not parse '" + gpelLoc + "'", e);
        }
        GpelProcess process;
        try {
            process = loadGpel(base, gpelLoclUri);
        } catch (GpelModelException we) {
            Throwable  t = we.getCause();
            if (t instanceof FileNotFoundException) {
                // let try loading GPEL from CLASSPATH
                try {
                    String locationOnClassapth = gpelLoc;
                    if (gpelLoc.charAt(0) != '/') {
                        locationOnClassapth = '/' + locationOnClassapth;
                    }
                    URL gpelOnClassPath = referenceClassForLoading.getResource(locationOnClassapth);
                    if (gpelOnClassPath != null) {
                        URI uri = URI.create(gpelOnClassPath.toString());
                        process = loadGpel(null, uri);
                    } else {
                        throw we;
                    }
                } catch (GpelModelException e) {
                    throw we;
                } catch (IllegalArgumentException e) {
                    throw we;
                }
            } else {
                throw we;
            }
        }
        return process;
    }
    
    
    public GpelProcess resolveImport(String namespace, URI base, URI optionalLocation)
    throws GpelModelException {
        Object hit = ns2Gpel.get(namespace);
        if (hit != null) {
            return (GpelProcess) hit;
        }
        if (optionalLocation != null) {
            return loadGpel(base, optionalLocation, true);
        }
        throw new GpelModelException("could not resolve import for namespace " + namespace
                                     + " with location " + optionalLocation);
    }
    
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(getClass().getName()).append("={");
        buf.append("List of namespaces in resolver cache=");
        
        for (Iterator i = ns2Gpel.keySet().iterator(); i.hasNext();) {
            buf.append(i.next());
            if (i.hasNext()) {
                buf.append(",");
            }
        }
        buf.append("}");
        return buf.toString();
    }
    
}

/*
* Indiana University Extreme! Lab Software License, Version 1.2
*
* Copyright (c) 2004-2005 The Trustees of Indiana University.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
* 1) All redistributions of source code must retain the above
*    copyright notice, the list of authors in the original source
*    code, this list of conditions and the disclaimer listed in this
*    license;
*
* 2) All redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the disclaimer
*    listed in this license in the documentation and/or other
*    materials provided with the distribution;
*
* 3) Any documentation included with all redistributions must include
*    the following acknowledgement:
*
*      "This product includes software developed by the Indiana
*      University Extreme! Lab.  For further information please visit
*      http://www.extreme.indiana.edu/"
*
*    Alternatively, this acknowledgment may appear in the software
*    itself, and wherever such third-party acknowledgments normally
*    appear.
*
* 4) The name "Indiana University" or "Indiana University
*    Extreme! Lab" shall not be used to endorse or promote
*    products derived from this software without prior written
*    permission from Indiana University.  For written permission,
*    please contact http://www.extreme.indiana.edu/.
*
* 5) Products derived from this software may not use "Indiana
*    University" name nor may "Indiana University" appear in their name,
*    without prior written permission of the Indiana University.
*
* Indiana University provides no reassurances that the source code
* provided does not infringe the patent or any other intellectual
* property rights of any other entity.  Indiana University disclaims any
* liability to any recipient for claims brought by any other entity
* based on infringement of intellectual property rights or otherwise.
*
* LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
* NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
* UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
* SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
* OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
* SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
* DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
* RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
* AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
* SOFTWARE.
*/


