/*
 * Decompiled with CFR 0.152.
 */
package org.gpel;

public class GpelVersion {
    private static final String SPEC_VERSION = "1.0.6";
    private static final String BUILD = "-BETA";
    private static final String PROJECT_NAME = "GPEL";
    private static final String PROJECT_URL = "http://gpel.org";
    private static final String IMPL_VERSION = "1.0.6-BETA";
    private static final String USER_AGENT_VERSION = "GPEL-Client/1.0.6-BETA";
    private static final String SERVER_VERSION = "GPEL-Engine/1.0.6-BETA";
    private static int VERSION_MAJOR = -1;
    private static int VERSION_MINOR = -1;
    private static int VERSION_INCREMENT = -1;

    public static String getProjectName() {
        return PROJECT_NAME;
    }

    public static String getProjectUrl() {
        return PROJECT_URL;
    }

    public static String getProjectSlashImplVersion() {
        return SERVER_VERSION;
    }

    public static String getServerHeader() {
        return SERVER_VERSION;
    }

    public static String getUserAgent() {
        return USER_AGENT_VERSION;
    }

    public static String getSpecVersion() {
        return SPEC_VERSION;
    }

    public static String getImplementationVersion() {
        return IMPL_VERSION;
    }

    public static void main(String[] args) {
        String SPEC_OPT = "-spec";
        String IMPL_OPT = "-impl";
        String SERVER_OPT = "-server";
        if (SPEC_OPT.equals(args[0])) {
            System.out.println(SPEC_VERSION);
        } else if (IMPL_OPT.equals(args[0])) {
            System.out.println(IMPL_VERSION);
        } else if (SERVER_OPT.equals(args[0])) {
            System.out.println(SERVER_VERSION);
        } else {
            System.err.println(GpelVersion.class.getName() + " Error: " + SPEC_OPT + " or " + IMPL_OPT + " or " + SERVER_OPT + " is required");
            System.exit(1);
        }
    }

    public static void exitIfRequiredVersionMissing(String version) {
        try {
            GpelVersion.requireVersion(version);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Error: could not find required version " + version + " of " + PROJECT_NAME + ": " + ex.getMessage());
            System.err.println("Please make sure that JAR file with GPEL with version " + version + " (or higher) is available.");
            System.err.println("Please make sure there is no more than one JAR file with GPEL");
            System.err.println("Exiting");
            System.exit(1);
        }
    }

    public static void requireVersion(String version) throws IllegalStateException {
        int[] parsed;
        if (VERSION_MAJOR < 0) {
            GpelVersion.extractCurrentVersion();
        }
        try {
            parsed = GpelVersion.parseVersion(version);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("could not parse GPEL version string " + version);
        }
        int major = parsed[0];
        int minor = parsed[1];
        int increment = parsed[2];
        if (major != VERSION_MAJOR) {
            throw new IllegalStateException("required GPEL " + version + " has different major version" + " from current " + SPEC_VERSION);
        }
        if (minor > VERSION_MINOR) {
            throw new IllegalStateException("required GPEL " + version + " has too big minor version" + " when compared to current " + SPEC_VERSION);
        }
        if (minor == VERSION_MINOR && increment > VERSION_INCREMENT) {
            throw new IllegalStateException("required GPEL " + version + " has too big increment version" + " when compared to current " + SPEC_VERSION);
        }
    }

    public static int[] parseVersion(String version) throws NumberFormatException {
        int[] parsed = new int[3];
        int firstDot = version.indexOf(46);
        if (firstDot == -1) {
            throw new NumberFormatException("expected version string N.M but there is no dot in " + version);
        }
        String majorVersion = version.substring(0, firstDot);
        parsed[0] = Integer.parseInt(majorVersion);
        if (parsed[0] < 0) {
            throw new NumberFormatException("major N version number in N.M can not be negative in " + version);
        }
        int secondDot = version.indexOf(46, firstDot + 1);
        String minorVersion = secondDot >= 0 ? version.substring(firstDot + 1, secondDot) : version.substring(firstDot + 1);
        parsed[1] = Integer.parseInt(minorVersion);
        if (parsed[1] < 0) {
            throw new NumberFormatException("minor M version number in N.M can not be negative in " + version);
        }
        if (secondDot >= 0) {
            String incrementVersion = version.substring(secondDot + 1);
            parsed[2] = Integer.parseInt(incrementVersion);
            if (parsed[2] < 0) {
                throw new NumberFormatException("increment K version number in N.M.K must be positive number in " + version);
            }
        }
        return parsed;
    }

    private static synchronized void extractCurrentVersion() throws IllegalStateException {
        int[] parsed;
        try {
            parsed = GpelVersion.parseVersion(SPEC_VERSION);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("internal problem: could not parse current GPEL version string 1.0.6");
        }
        VERSION_MAJOR = parsed[0];
        VERSION_MINOR = parsed[1];
        VERSION_INCREMENT = parsed[2];
    }
}

