/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import org.gpel.client.GcAtomResource;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.gpel.client.GcWebResourceType;
import org.gpel.client.util.base64.Base64;
import org.xmlpull.infoset.XmlElement;

public class GcBinaryWebResource
extends GcAtomResource
implements GcWebResource {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";

    public GcBinaryWebResource(String resourceName, byte[] binaryContent) {
        this(resourceName, binaryContent, DEFAULT_MIME_TYPE);
    }

    public GcBinaryWebResource(String resourceName, byte[] binaryContent, String mimeType) {
        super(resourceName, mimeType);
        this.setBinaryContent(binaryContent);
        this.setMimeType(mimeType);
    }

    public GcBinaryWebResource(XmlElement atomRes) {
        super(atomRes);
    }

    public void setBinaryContent(byte[] binaryContent) {
        String s = new String(Base64.encode(binaryContent));
        XmlElement contentEl = this.getContentEl(true);
        contentEl.removeAllChildren();
        contentEl.addChild((Object)s);
    }

    public byte[] getBinaryContent() {
        XmlElement contentEl = this.getContentEl(true);
        String s = contentEl.requiredText();
        byte[] binaryContent = Base64.decode(s.toCharArray());
        return binaryContent;
    }

    @Override
    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException();
        }
        if (!GcWebResourceType.BINARY.equals((Object)GcUtil.categorizeContentType(mimeType))) {
            throw new IllegalArgumentException("MIME type must be binary not " + mimeType);
        }
        super.setMimeType(mimeType);
    }
}

