/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import java.net.URI;
import org.gpel.GpelConstants;
import org.gpel.client.GcException;
import org.gpel.client.GcLinkFilter;
import org.gpel.client.GcLinksResource;
import org.gpel.client.GcPriority;
import org.gpel.client.GcState;
import org.gpel.client.GcUtil;
import org.gpel.client.GpelClient;
import org.gpel.client.http.GcHttpRequest;
import org.gpel.client.http.GcHttpResponse;
import org.gpel.logger.GLogger;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;

public class GcInstance
extends GcLinksResource {
    private static final GLogger logger = GLogger.getLogger();
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    public static final String MIME_TYPE = "application/x-gpel-instance+xml";
    public static final String TYPE_NAME = "instance";
    public static final String START_ACTION = "gpel-instance-start";
    public static final String STEP_ACTION = "gpel-instance-step";
    public static final String PAUSE_ACTION = "gpel-instance-pause";
    public static final String RESUME_ACTION = "gpel-instance-resume";
    public static final String STOP_ACTION = "gpel-instance-stop";
    private static final String PRIORITY_EL = "priority";

    protected GcInstance(GpelClient client, String title, GcLinkFilter filter) throws GcException {
        super(client, title, builder.newFragment(GpelConstants.GPEL_NS, TYPE_NAME), filter, MIME_TYPE);
        this.setPriority(GcPriority.SILVER);
    }

    public GcInstance(XmlElement atomRes) {
        super(atomRes);
    }

    public void store() {
        this.getClient().storeInstance(this);
    }

    public URI getInstanceId() throws GcException {
        return this.getId();
    }

    public GcPriority getPriority() {
        XmlElement priorityEl = this.getXmlContent().requiredElement(PRIORITY_EL);
        String s = priorityEl.requiredText();
        return GcPriority.valueOf(s);
    }

    public void setPriority(GcPriority status) {
        XmlElement priority = this.getXmlContent().element(null, PRIORITY_EL, true);
        priority.setText(status.toString());
    }

    public GcState retrieveCurrentState() {
        GcState oldState = (GcState)this.getLinkWithRel("http://schemas.gpel.org/2005/grid-process/state");
        if (null == oldState) {
            throw new IllegalStateException("internal");
        }
        String href = oldState.getId().toString();
        String rel = oldState.getRel();
        GcState newState = (GcState)this.loadXmlResourceLink(href, rel);
        this.replaceLinkWithRel(newState);
        return newState;
    }

    public GcState start() {
        return this.executeInstanceAction(START_ACTION);
    }

    public GcState step() {
        return this.executeInstanceAction(STEP_ACTION);
    }

    public GcState pause() {
        return this.executeInstanceAction(PAUSE_ACTION);
    }

    public GcState resume() {
        return this.executeInstanceAction(RESUME_ACTION);
    }

    private GcState executeInstanceAction(String action) {
        URI tloc = this.getClient().mapIdToLocation(this.getInstanceId());
        URI loc = URI.create(tloc.toString() + "?action=" + action);
        logger.finest("loc=" + loc);
        GcHttpRequest.Method httpMethod = GcHttpRequest.Method.POST;
        GcHttpRequest req = new GcHttpRequest(httpMethod, loc, "application/atom+xml; charset=utf-8", builder.newFragment(GcUtil.ATOM_NS, "entry"));
        GcHttpResponse resp = this.getClient().getTransport().perform(req);
        if (!resp.hasContent()) {
            throw new GcException("expected XML result when POSTing to " + loc);
        }
        GcState state = (GcState)this.getClient().getResourceFromHttpFactory().createResourceFromHttp(resp, null);
        state.setLocation(resp.getLocation());
        this.replaceLinkWithRel(state);
        return state;
    }
}

