/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gpel.GpelConstants;
import org.gpel.client.GcDefaultSupportedLinksFilter;
import org.gpel.client.GcException;
import org.gpel.client.GcLink;
import org.gpel.client.GcLinkFilter;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.gpel.client.GcXmlWebResource;
import org.gpel.client.GpelClient;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;

public abstract class GcLinksResource
extends GcXmlWebResource {
    public static final GcLinkFilter DEFAULT_LINKS_FILTER = new GcDefaultSupportedLinksFilter();
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private List<GcWebResource> linkedResources = new ArrayList<GcWebResource>();
    private GcLinkFilter filter;
    private GpelClient client;

    protected GcLinksResource(GpelClient client, String title, XmlElement contentEl, GcLinkFilter filter, String mimeType) throws GcException {
        super(title, contentEl, mimeType);
        this.client = client;
        this.filter = filter;
    }

    public GcLinksResource(XmlElement atomRes) {
        super(atomRes);
        this.filter = DEFAULT_LINKS_FILTER;
    }

    public void setFilter(GcLinkFilter filter) {
        this.filter = filter;
    }

    public GcLinkFilter getFilter() {
        return this.filter;
    }

    public void setClient(GpelClient client) {
        this.client = client;
    }

    public GpelClient getClient() {
        return this.client;
    }

    public List<GcWebResource> getLinks() {
        return this.linkedResources;
    }

    public GcWebResource getLinkWithId(URI id) {
        for (GcWebResource gwr : this.getLinks()) {
            if (!gwr.getId().equals(id)) continue;
            return gwr;
        }
        return null;
    }

    public GcWebResource getLinkWithRel(String rel) {
        if (rel == null) {
            throw new IllegalArgumentException();
        }
        for (GcWebResource gwr : this.getLinks()) {
            if (!rel.equals(gwr.getRel())) continue;
            return gwr;
        }
        return null;
    }

    public GcWebResource getLinkWithTitleAndRel(String title, String rel) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        if (rel == null) {
            throw new IllegalArgumentException();
        }
        for (GcWebResource gwr : this.getLinks()) {
            if (!title.equals(gwr.getTitle()) || !rel.equals(gwr.getRel())) continue;
            return gwr;
        }
        return null;
    }

    public void setLinks(List<GcWebResource> links) {
        this.linkedResources = links;
    }

    public void setLinks(GcWebResource[] linkArr) {
        this.linkedResources = new ArrayList<GcWebResource>(linkArr.length);
        for (GcWebResource linkedRes : linkArr) {
            if (linkedRes.getRel() == null) {
                throw new GcException("every linked resource must have rel missing for " + linkedRes.getLocation());
            }
            this.linkedResources.add(linkedRes);
        }
        this.removeAllSupportedLinks();
    }

    public void replaceLinkWithRel(GcWebResource res) {
        if (res.getRel() == null) {
            throw new GcException("every linked resource must have rel but missing for " + res);
        }
        this.removeLinksWithRel(res.getRel());
        this.linkedResources.add(res);
    }

    private void removeLinksWithRel(String rel) {
        if (rel == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<GcWebResource> forRemoval = new ArrayList<GcWebResource>();
        for (GcWebResource res : this.linkedResources) {
            String linkRel = res.getRel();
            if (!rel.equals(linkRel)) continue;
            forRemoval.add(res);
        }
        for (GcWebResource res : forRemoval) {
            this.linkedResources.remove(res);
        }
    }

    protected void saveLinkedResources() throws GcException {
        if (this.client == null) {
            throw new GcException("this template is contained as a link and its linked resources can not be saved");
        }
        for (GcWebResource linkedRes : this.linkedResources) {
            try {
                this.client.storeResource(linkedRes);
            }
            catch (Exception e) {
                String loc = "";
                if (linkedRes.getLocation() != null) {
                    loc = " to location=" + linkedRes.getLocation();
                }
                String title = linkedRes.getTitle();
                throw new GcException("failed to store resource title=" + title + loc, e);
            }
        }
        this.recomputeLinks();
        this.client.storeResource(this);
    }

    public void loadResourcesFromLinks() throws GcException {
        this.linkedResources.clear();
        for (GcLink link : this.supportedLinks()) {
            String rel = link.getRel();
            String href = link.getHref();
            this.linkedResources.add(this.loadXmlResourceLink(href, rel));
        }
    }

    protected GcWebResource loadXmlResourceLink(String href, String rel) throws GcException {
        URI loc = URI.create(href);
        GcWebResource res = this.client.loadResource(loc, rel);
        res.setRel(rel);
        return res;
    }

    private void recomputeLinks() {
        this.removeAllSupportedLinks();
        for (GcWebResource linkedRes : this.linkedResources) {
            URI href = linkedRes.getLocation();
            URI id = this.client.mapLocationToId(href);
            String rel = linkedRes.getRel();
            GcLink link = new GcLink(id, rel);
            this.xml().addElement(link.xml());
        }
    }

    private void removeAllSupportedLinks() {
        ArrayList<GcLink> linksToRemove = new ArrayList<GcLink>(this.linkedResources.size());
        for (GcLink link : this.supportedLinks()) {
            linksToRemove.add(link);
        }
        for (GcLink link : linksToRemove) {
            this.xml().removeChild((Object)link.xml());
        }
    }

    private Iterable<GcLink> supportedLinks() {
        final Iterator allLinksIter = this.xml().elements(GcUtil.ATOM_NS, "link").iterator();
        GcLinkFilter f = this.filter;
        return new Iterable<GcLink>(){

            @Override
            public Iterator<GcLink> iterator() {
                return new Iterator<GcLink>(){
                    private XmlElement nextLink = this.findNextLink();

                    private XmlElement findNextLink() {
                        XmlElement e = null;
                        while (allLinksIter.hasNext()) {
                            XmlElement link = (XmlElement)allLinksIter.next();
                            GcLink glink = (GcLink)link.viewAs(GcLink.class);
                            if (!GcLinksResource.this.filter.accept(glink)) continue;
                            e = link;
                            break;
                        }
                        return e;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextLink != null;
                    }

                    @Override
                    public GcLink next() {
                        if (this.nextLink == null) {
                            throw new IllegalStateException();
                        }
                        XmlElement oldNextLink = this.nextLink;
                        this.nextLink = this.findNextLink();
                        return (GcLink)oldNextLink.viewAs(GcLink.class);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

