/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import org.gpel.client.GcAtomResource;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.gpel.client.GcWebResourceType;
import org.xmlpull.infoset.XmlElement;

public class GcTextWebResource
extends GcAtomResource
implements GcWebResource {
    public static final String DEFAULT_MIME_TYPE = "text/plain";

    public GcTextWebResource(String title, String textContent) {
        this(title, textContent, DEFAULT_MIME_TYPE);
    }

    public GcTextWebResource(String title, String textContent, String mimeType) {
        super(title, mimeType);
        this.setMimeType(mimeType);
        this.setTextContent(textContent);
    }

    public GcTextWebResource(XmlElement atomRes) {
        super(atomRes);
    }

    private void setTextContent(String textContent) {
        XmlElement contentEl = this.getContentEl(true);
        contentEl.setText(textContent);
    }

    public String getTextContent() {
        XmlElement contentEl = this.getContentEl(true);
        String textContent = contentEl.requiredText();
        return textContent;
    }

    @Override
    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException();
        }
        if (!GcWebResourceType.TEXT.equals((Object)GcUtil.categorizeContentType(mimeType))) {
            throw new IllegalArgumentException("content type must be text and not " + mimeType);
        }
        super.setMimeType(mimeType);
    }
}

