/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import org.gpel.GpelConstants;
import org.gpel.client.GcAtomResource;
import org.gpel.client.GcException;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.gpel.client.GcWebResourceType;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;

public class GcXmlWebResource
extends GcAtomResource
implements GcWebResource {
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private static final String DEFAULT_MIME_TYPE = "application/xml";

    public GcXmlWebResource(String resourceName, XmlElement wrapped, String mimeType) {
        super(resourceName, mimeType);
        if (wrapped == null) {
            throw new IllegalArgumentException();
        }
        this.setXmlContent(wrapped);
    }

    public GcXmlWebResource(XmlElement atomRes) {
        super(atomRes);
    }

    public XmlElement getXmlContent() {
        XmlElement contentEl = this.getContentEl(true);
        XmlElement el = contentEl != null ? (XmlElement)contentEl.requiredElementContent().iterator().next() : this.xml();
        return el;
    }

    public void setXmlContent(XmlElement xmlContent) {
        XmlElement contentEl = this.getContentEl(true);
        if (contentEl == null) {
            throw new GcException("XML resource must be first saved to have modifiable content");
        }
        contentEl.removeAllChildren();
        contentEl.addChild((Object)xmlContent);
    }

    @Override
    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException();
        }
        if (!GcWebResourceType.XML.equals((Object)GcUtil.categorizeContentType(mimeType))) {
            throw new IllegalArgumentException("content type must be xml and not " + mimeType);
        }
        super.setMimeType(mimeType);
    }
}

