/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client.http;

import java.net.URI;
import org.xmlpull.infoset.XmlElement;

public class GcHttpRequest {
    private Method method;
    private URI location;
    private String contentType;
    private XmlElement xmlContent;
    private String textContent;
    private byte[] binaryContent;
    private boolean withAuthz = true;

    public GcHttpRequest(Method method, URI location) {
        this(method, location, true);
    }

    public GcHttpRequest(Method method, URI location, boolean secure) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        if (!Method.GET.equals((Object)method) && !Method.DELETE.equals((Object)method)) {
            throw new IllegalArgumentException("method must be " + (Object)((Object)Method.GET) + " or " + (Object)((Object)Method.DELETE) + " for no content operation");
        }
        this.method = method;
        this.location = location;
        this.withAuthz = secure;
    }

    public GcHttpRequest(Method method, URI location, String contentType, XmlElement xmlContent) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        if (!Method.POST.equals((Object)method) && !Method.PUT.equals((Object)method)) {
            throw new IllegalArgumentException("method must be " + (Object)((Object)Method.POST) + " or " + (Object)((Object)Method.PUT) + " for content");
        }
        this.method = method;
        this.location = location;
        this.contentType = contentType;
        this.xmlContent = xmlContent;
    }

    public GcHttpRequest(Method method, URI location, String contentType, String textContent) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        if (!Method.POST.equals((Object)method) && !Method.PUT.equals((Object)method)) {
            throw new IllegalArgumentException("method must be POST or PUT for content");
        }
        this.method = method;
        this.location = location;
        this.contentType = contentType;
        this.textContent = textContent;
    }

    public GcHttpRequest(Method method, URI location, String contentType, byte[] binaryContent) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        if (!Method.POST.equals((Object)method) && !Method.PUT.equals((Object)method)) {
            throw new IllegalArgumentException("method must be POST or PUT for content");
        }
        this.method = method;
        this.location = location;
        this.contentType = contentType;
        this.binaryContent = binaryContent;
    }

    public boolean hasContent() {
        return this.xmlContent != null || this.textContent != null || this.binaryContent != null;
    }

    public XmlElement getXmlContent() {
        return this.xmlContent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public byte[] getBinaryContent() {
        return this.binaryContent;
    }

    public String getContentType() {
        return this.contentType;
    }

    public URI getLocation() {
        return this.location;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean useAuthz() {
        return this.withAuthz;
    }

    public String toString() {
        return super.toString() + "{method=" + (Object)((Object)this.method) + " location=" + this.location + " contentType=" + this.contentType + " xmlContent=" + this.xmlContent + " textContent=" + this.textContent + " binaryContent=" + this.binaryContent + " withAuthz=" + this.withAuthz + "}";
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

