/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.logger;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class GLogger {
    public static final GLogger global = new GLogger("global", null);
    public static final String PROPERTY_PREFIX = "";
    public static final String PROPERTY_LOG = "log";
    public static final String PROPERTY_SHOWTIME = "showtime";
    public static final String PROPERTY_DEBUG = "debug";
    public static final String PROPERTY_WRAPCOL = "log.wrapcol";
    private static String PROPERTY_MULTILINE = "log.multiline";
    private static final boolean QUIET = false;
    private static final boolean DEBUG = false;
    private static final boolean WARN = false;
    public static final int DEFAULT_NESTING_LEVEL = 4;
    private static final String LOGGER_NAME = GLogger.class.getName();
    private static PrintStream sink = System.err;
    private static boolean guessFailed;
    private static boolean showTime;
    private static int wrapCol;
    private static boolean multiline;
    private Level myLevel;
    private String myName;

    protected GLogger(String name, String resourceBundleName) {
        this.myName = name;
    }

    public static GLogger getAnonymousMLogger() {
        return new GLogger(null, null);
    }

    public static GLogger getLogger() {
        String name = PROPERTY_PREFIX;
        Location loc = new Location();
        if (GLogger.guessLocation(loc, 2)) {
            name = loc.klass;
        }
        return GLogger.getLogger(name);
    }

    public static GLogger getLogger(String name) {
        GLogger logger = LogManager.getLogManager().getLogger(name);
        return logger;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.myLevel.intValue();
    }

    public final boolean isSevereEnabled() {
        return this.isLoggable(Level.SEVERE);
    }

    public final boolean isWariningEnabled() {
        return this.isLoggable(Level.WARNING);
    }

    public final boolean isInfoEnabled() {
        return this.isLoggable(Level.INFO);
    }

    public final boolean isConfigEnabled() {
        return this.isLoggable(Level.CONFIG);
    }

    public final boolean isFineEnabled() {
        return this.isLoggable(Level.FINE);
    }

    public final boolean isFinerEnabled() {
        return this.isLoggable(Level.FINER);
    }

    public final boolean isFinestEnabled() {
        return this.isLoggable(Level.FINEST);
    }

    public void setLevel(Level newLevel) {
        this.myLevel = newLevel;
    }

    public Level getLevel() {
        return this.myLevel;
    }

    public static String parametersToList(Object[] params) {
        if (params == null) {
            return " array with parameters is null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i]);
            if (i >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append('}');
        return sb.toString();
    }

    public void entering() {
        this.logg(Level.FINER, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.logg(Level.FINER, sourceClass + ":" + sourceMethod + " ENTRY");
    }

    public void entering(Object param1) {
        this.logg(Level.FINER, "ENTRY " + param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logg(Level.FINER, sourceClass + ":" + sourceMethod + " ENTRY " + param1);
    }

    public void entering(Object[] params) {
        this.logg(Level.FINER, "ENTRY " + GLogger.parametersToList(params));
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logg(Level.FINER, sourceClass + ":" + sourceMethod + " ENTRY " + GLogger.parametersToList(params));
    }

    public void exiting() {
        this.logg(Level.FINER, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.logg(Level.FINER, sourceClass + ":" + sourceMethod + " RETURN");
    }

    public Object exiting(Object result) {
        this.logg(Level.FINER, "RETURN " + result);
        return result;
    }

    public Object exiting(String sourceClass, String sourceMethod, Object result) {
        this.logg(Level.FINER, sourceClass + ":" + sourceMethod + " RETURN " + result);
        return result;
    }

    public Throwable throwing(Throwable thrown) {
        this.logg(Level.SEVERE, "THROW", thrown);
        return thrown;
    }

    public Throwable throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logg(Level.SEVERE, sourceClass + ":" + sourceMethod + " THROW", thrown);
        return thrown;
    }

    public Throwable caught(Throwable thrown) {
        this.logg(Level.SEVERE, "CAUGHT", thrown);
        return thrown;
    }

    public Throwable caught(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logg(Level.SEVERE, sourceClass + ":" + sourceMethod + " CAUGHT", thrown);
        return thrown;
    }

    public void severe(String msg) {
        this.logg(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.logg(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.logg(Level.INFO, msg);
    }

    public void config(String msg) {
        this.logg(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.logg(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.logg(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.logg(Level.FINEST, msg);
    }

    public void log(Level level, String msg) {
        this.logg(level, msg);
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.logg(level, msg, thrown);
    }

    public void log(Level level, String msg, Object param1) {
        this.logg(level, msg + " " + param1);
    }

    public void log(Level level, String msg, Object[] params) {
        this.logg(level, msg + " " + GLogger.parametersToList(params));
    }

    public void severe(String msg, Throwable thrown) {
        this.logg(Level.SEVERE, msg, thrown);
    }

    public void warning(String msg, Throwable thrown) {
        this.logg(Level.WARNING, msg, thrown);
    }

    public void info(String msg, Throwable thrown) {
        this.logg(Level.INFO, msg, thrown);
    }

    public void config(String msg, Throwable thrown) {
        this.logg(Level.CONFIG, msg, thrown);
    }

    public void fine(String msg, Throwable thrown) {
        this.logg(Level.FINE, msg, thrown);
    }

    public void finer(String msg, Throwable thrown) {
        this.logg(Level.FINER, msg, thrown);
    }

    public void finest(String msg, Throwable thrown) {
        this.logg(Level.FINEST, msg, thrown);
    }

    public static synchronized PrintStream getSink() {
        return sink;
    }

    public static synchronized void setSink(PrintStream ps) {
        System.err.println(LOGGER_NAME + " sink=" + ps);
        if (sink != System.err) {
            String s = global.preapareLogMessage(Level.ALL, 4, LOGGER_NAME + ".setSink() can only be called once");
            ps.println(s);
            throw new IllegalArgumentException("sink can be only set once");
        }
        sink = ps;
    }

    public void logg(Level level, String msg) {
        this.logg(level, msg, null, 5);
    }

    public void logg(Level level, String msg, Throwable thrown) {
        this.logg(level, msg, thrown, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logg(Level level, String msg, Throwable thrown, int nestingLevel) {
        if (!this.isLoggable(level)) {
            return;
        }
        String s = this.preapareLogMessage(level, nestingLevel, (multiline ? "\n" : PROPERTY_PREFIX) + msg);
        if (wrapCol > 0) {
            s = GLogger.wrap(s, wrapCol);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (thrown == null) {
                sink.println();
                sink.print(s);
            } else {
                sink.println();
                sink.print(s + " expection: ");
                thrown.printStackTrace(sink);
            }
        }
    }

    private static String wrap(String s, int wrapCol) {
        int len = s.length();
        if (len < wrapCol) {
            return s;
        }
        int extraLines = len / wrapCol + 1;
        StringBuffer buf = new StringBuffer(len + 2 * extraLines);
        int count = 0;
        int start = 0;
        for (int pos = 0; pos < len; ++pos) {
            char c = s.charAt(pos);
            if (c == '\n' || c == '\r') {
                count = 0;
                continue;
            }
            if (c == '\t') {
                count += 8;
                continue;
            }
            if (count > wrapCol) {
                char backC;
                int i;
                for (i = pos; i > start && !Character.isWhitespace(backC = s.charAt(i)); --i) {
                }
                if (i > start) {
                    buf.append(s.substring(start, i));
                    start = pos = i + 1;
                } else {
                    buf.append(s.substring(start, pos));
                    start = pos;
                }
                buf.append("\n");
                count = 0;
                continue;
            }
            ++count;
        }
        buf.append(s.substring(start));
        return buf.toString();
    }

    private String preapareLogMessage(Level level, int nestingLevel, String msg) {
        Location myLoc = new Location();
        StringBuffer buf = new StringBuffer(80);
        if (GLogger.guessLocation(myLoc, nestingLevel)) {
            String s;
            int i;
            boolean needsToPrintLoggerNameDifferentFromPackage = true;
            String loggerNameToPrint = this.myName;
            if (myLoc.fileName != null && (i = myLoc.fileName.lastIndexOf(".java")) > 0 && this.myName.endsWith(s = myLoc.fileName.substring(0, i))) {
                int j = this.myName.length() - s.length();
                loggerNameToPrint = this.myName.substring(0, j);
                needsToPrintLoggerNameDifferentFromPackage = false;
            }
            if (showTime) {
                long now = System.currentTimeMillis();
                GLogger.formatTime(now, buf);
                buf.append(' ');
            }
            if (!Level.ALL.equals(level)) {
                buf.append(level);
                buf.append(PROPERTY_PREFIX);
            }
            String tname = Thread.currentThread().getName();
            buf.append('[');
            buf.append(tname);
            if (needsToPrintLoggerNameDifferentFromPackage) {
                buf.append(' ');
                buf.append(loggerNameToPrint);
            }
            buf.append(']');
            buf.append(": ");
            buf.append(msg);
            buf.append("\n\tat ");
            buf.append(myLoc.klass).append('.');
            buf.append(myLoc.method);
            if (myLoc.line != -1) {
                buf.append("(");
                buf.append(myLoc.fileName).append(':').append(myLoc.line);
                buf.append(")");
            } else {
                buf.append(myLoc.fileName).append(' ').append(myLoc.klass).append(' ');
            }
        } else {
            buf.append(this.myName).append(' ').append(msg);
        }
        return buf.toString();
    }

    private static boolean guessLocation(Location loc, int nestingLevel) {
        if (guessFailed) {
            return false;
        }
        Throwable throwable = new Throwable();
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        String s = sw.toString() + "\n";
        String line = null;
        try {
            int k;
            int i = s.indexOf(10);
            for (int lines = 0; lines < nestingLevel; ++lines) {
                i = s.indexOf(10, i + 1);
            }
            int j = s.indexOf(10, i + 1);
            line = s.substring(i + 1, j);
            if ((i = line.indexOf(40)) < 0) {
                line = "at <Unknown>.<undetermined>(<Unknown>.java:-1)";
                i = line.indexOf(40);
            }
            loc.method = line.substring(0, i);
            j = loc.method.lastIndexOf(46);
            if (j < 0) {
                loc.klass = PROPERTY_PREFIX;
                k = loc.method.lastIndexOf("at ");
                loc.method = loc.method.substring(k + 3);
            } else {
                k = loc.method.lastIndexOf("at ");
                loc.klass = loc.method.substring(k + 3, j);
                loc.method = loc.method.substring(j + 1);
            }
            int packagePos = loc.klass.lastIndexOf(46);
            if (packagePos > 0) {
                loc.packageName = loc.klass.substring(0, packagePos);
            }
            j = line.lastIndexOf(41);
            String pos = line.substring(i + 1, j);
            loc.line = -1;
            loc.fileName = pos;
            i = pos.indexOf(58);
            if (i >= 0) {
                loc.fileName = pos.substring(0, i);
                String lineNo = PROPERTY_PREFIX;
                try {
                    lineNo = pos.substring(i + 1);
                    int posComma = lineNo.indexOf(44);
                    if (posComma != -1) {
                        lineNo = lineNo.substring(0, posComma);
                    }
                    loc.line = Integer.parseInt(lineNo);
                }
                catch (NumberFormatException ex) {
                    System.err.println(GLogger.class.getName() + " disabling advanced logging  " + " - can't parse" + " string: '" + line + "'" + " for line number '" + lineNo + "'" + " stack trace:---\n" + s + "\n---");
                    ex.printStackTrace();
                    guessFailed = true;
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            System.err.println(GLogger.class.getName() + " disabling advanced logging - " + " location guess failed for stack trace" + "on line: '" + line + "'\n of stack trace:---\n" + s + "---");
            ex.printStackTrace();
            guessFailed = true;
        }
        return !guessFailed;
    }

    public static void setCmdNames(String names) {
        if (names != null) {
            System.err.println(LOGGER_NAME + " $Revision: 1.5 $ $Date: 2006/12/07 04:55:33 $ (GMT)" + " configured as '" + names + "'");
        }
        if (names != null) {
            if (names.indexOf(44) == -1) {
                GLogger.setCmdLogger(names);
            } else {
                StringTokenizer tok = new StringTokenizer(names, ",");
                while (tok.hasMoreTokens()) {
                    GLogger.setCmdLogger(tok.nextToken());
                }
            }
        }
    }

    private static void setCmdLogger(String name) {
        Level level = Level.ALL;
        int pos = name.indexOf(58);
        if (pos != -1) {
            String levelName = name.substring(pos + 1);
            level = Level.parse(levelName);
            name = name.substring(0, pos);
        }
        GLogger l = LogManager.getLogManager().getLogger(name, level);
        LogManager.getLogManager().setLevel(name, level);
    }

    public static boolean getMultiline() {
        return multiline;
    }

    public static void setMultiline(boolean enable) {
        multiline = enable;
    }

    public static int getWrapCol() {
        return wrapCol;
    }

    public static void setWrapCol(int i) {
        wrapCol = i;
    }

    public static boolean getShowTime() {
        return showTime;
    }

    public static void setShowTime(boolean enable) {
        showTime = enable;
    }

    public static void formatTime(long time, StringBuffer buf) {
        long ms = time % 1000L;
        long ss = (time /= 1000L) % 60L;
        long mm = (time /= 60L) % 60L;
        long hh = (time /= 60L) % 24L;
        if (hh < 10L) {
            buf.append('0');
        }
        buf.append(hh).append(':');
        if (mm < 10L) {
            buf.append('0');
        }
        buf.append(mm).append(':');
        if (ss < 10L) {
            buf.append('0');
        }
        buf.append(ss).append('.');
        if (ms < 100L) {
            buf.append('0');
        }
        if (ms < 10L) {
            buf.append('0');
        }
        buf.append(ms);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName() + "={");
        buf.append(this.getName() + ":" + this.getLevel());
        buf.append("}");
        return buf.toString();
    }

    static {
        showTime = true;
        try {
            String wrapColProperty;
            String multilineProperty;
            String s;
            String names = null;
            try {
                names = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(GLogger.PROPERTY_LOG);
                    }
                });
            }
            catch (AccessControlException ace) {
                // empty catch block
            }
            String debug = System.getProperty(PROPERTY_DEBUG);
            if (names == null && debug != null && !"false".equals(s = debug.toLowerCase()) && !"off".equals(s)) {
                names = ":ALL";
            }
            GLogger.setCmdNames(names);
            String requestedShowTime = System.getProperty(PROPERTY_SHOWTIME);
            if (requestedShowTime != null) {
                showTime = requestedShowTime.length() > 0 ? Boolean.getBoolean(requestedShowTime) : true;
            }
            if ((multilineProperty = System.getProperty(PROPERTY_MULTILINE)) != null) {
                multiline = multilineProperty.length() > 0 ? Boolean.getBoolean(multilineProperty) : true;
            }
            if ((wrapColProperty = System.getProperty(PROPERTY_WRAPCOL)) != null) {
                wrapCol = Integer.parseInt(wrapColProperty);
            }
        }
        catch (IllegalArgumentException ex) {
            System.err.println("can't set logging " + ex);
            ex.printStackTrace();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public static class Level
    implements Serializable {
        private static Map levels = new HashMap();
        public static final Level OFF = new Level("OFF", 10000);
        public static final Level SEVERE = new Level("SEVERE", 7777);
        public static final Level WARNING = new Level("WARNING", 666);
        public static final Level INFO = new Level("INFO", 55);
        public static final Level CONFIG = new Level("CONFIG", 44);
        public static final Level FINE = new Level("FINE", 33);
        public static final Level FINER = new Level("FINER", 22);
        public static final Level FINEST = new Level("FINEST", 11);
        public static final Level ALL = new Level("ALL", 0);
        private int value;
        private String name;

        protected Level(String name, int value) {
            this.name = name;
            this.value = value;
            levels.put(name, this);
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object ox) {
            Level other;
            if (ox == null) {
                return false;
            }
            try {
                other = (Level)ox;
            }
            catch (ClassCastException e) {
                return false;
            }
            return this.value == other.intValue();
        }

        public final int intValue() {
            return this.value;
        }

        public final String toString() {
            return this.name;
        }

        public static Level parse(String name) {
            Level l = (Level)levels.get(name);
            if (l == null) {
                throw new IllegalArgumentException("unknown debug level: " + name);
            }
            return l;
        }
    }

    public static class LogManager {
        private static final boolean DEBUG = false;
        private static LogManager instance = new LogManager();
        private SortedMap loggers = new TreeMap();

        LogManager() {
        }

        public static LogManager getLogManager() {
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addLogger(GLogger l) {
            String name = l.getName();
            SortedMap sortedMap = this.loggers;
            synchronized (sortedMap) {
                this.loggers.put(name, l);
            }
            Level level = l.getLevel();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Level getLevel(String name) {
            Level level = Level.OFF;
            String origName = name;
            while (name != null) {
                GLogger logger;
                SortedMap sortedMap = this.loggers;
                synchronized (sortedMap) {
                    logger = (GLogger)this.loggers.get(name);
                }
                if (logger != null) {
                    level = logger.getLevel();
                    break;
                }
                int pos = name.lastIndexOf(46);
                if (pos > 0) {
                    name = name.substring(0, pos);
                    continue;
                }
                if (name.length() > 0) {
                    name = GLogger.PROPERTY_PREFIX;
                    continue;
                }
                name = null;
            }
            return level;
        }

        public GLogger getLogger(String name) {
            return this.getLogger(name, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GLogger getLogger(String name, Level newLevel) {
            GLogger logger;
            SortedMap sortedMap = this.loggers;
            synchronized (sortedMap) {
                logger = (GLogger)this.loggers.get(name);
            }
            if (logger == null) {
                logger = new GLogger(name, null);
                if (newLevel == null) {
                    Level level = this.getLevel(name);
                    logger.setLevel(level);
                }
                this.addLogger(logger);
            }
            if (newLevel != null) {
                logger.setLevel(newLevel);
            }
            return logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getLoggerNames() {
            Enumeration e;
            SortedMap sortedMap = this.loggers;
            synchronized (sortedMap) {
                e = Collections.enumeration(this.loggers.keySet());
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLevel(String name, Level level) {
            GLogger l = this.getLogger(name);
            SortedMap sortedMap = this.loggers;
            synchronized (sortedMap) {
                Map.Entry me;
                String keyName;
                SortedMap tail = this.loggers.tailMap(name);
                Set entries = tail.entrySet();
                Iterator i = entries.iterator();
                while (i.hasNext() && (keyName = (me = i.next()).getKey()).startsWith(name)) {
                    l = (GLogger)me.getValue();
                    l.setLevel(level);
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName() + "={ ");
            SortedMap tail = this.loggers.tailMap(GLogger.PROPERTY_PREFIX);
            Set entries = tail.entrySet();
            GLogger l = null;
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String keyName = me.getKey();
                Level level = null;
                l = (GLogger)me.getValue();
                if (l == null) continue;
                level = l.getLevel();
                buf.append(keyName + ":" + level);
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            buf.append(" }");
            return buf.toString();
        }
    }

    public static final class Log {
        public static final boolean ON = true;
    }

    private static class Location {
        String klass;
        String method;
        String fileName;
        int line;
        String packageName;

        private Location() {
        }
    }
}

