/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.model;

import java.util.Iterator;
import org.gpel.model.GpelActivity;
import org.gpel.model.GpelCondition;
import org.gpel.model.GpelContainerActivity;
import org.gpel.model.GpelElse;
import org.gpel.model.GpelElseIf;
import org.gpel.model.GpelModelValidationException;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public abstract class GpelContainerActivityOfOne
extends GpelContainerActivity {
    public GpelContainerActivityOfOne(String typeName, XmlElement target) {
        super(typeName, target);
    }

    public GpelContainerActivityOfOne(XmlNamespace ns, String typeName) {
        super(ns, typeName);
    }

    @Override
    public void addActivity(GpelActivity activity) {
        if (this.getActivity(false) != null) {
            throw new IllegalStateException("this container can have only one activity that is already set " + this.xmlString());
        }
        this.xml().addElement(activity.xml());
    }

    public GpelActivity oneActivity() {
        return this.getActivity();
    }

    public GpelActivity getActivity() {
        return this.getActivity(true);
    }

    protected GpelActivity getActivity(boolean requireActivity) {
        GpelActivity activity = null;
        for (XmlElement el : this.xml().requiredElementContent()) {
            GpelActivity possibleActivity = GpelContainerActivityOfOne.convertElementToActivityIfPossible(el);
            if (possibleActivity == null || this.isRestrictedActivity(possibleActivity)) continue;
            if (activity != null) {
                throw new GpelModelValidationException("only one activity is allowed in " + this.xmlString());
            }
            activity = possibleActivity;
        }
        if (activity == null && requireActivity) {
            throw new GpelModelValidationException("activity is required in " + this.xmlString());
        }
        return activity;
    }

    protected boolean isRestrictedActivity(GpelActivity possibleActivity) {
        return possibleActivity instanceof GpelCondition || possibleActivity instanceof GpelElse || possibleActivity instanceof GpelElseIf;
    }

    public void setActivity(GpelActivity newActivity) {
        if (this.isRestrictedActivity(newActivity)) {
            throw new GpelModelValidationException("activity " + newActivity.xmlString() + " is not allowed");
        }
        GpelActivity oldActivity = this.getActivity(false);
        if (oldActivity != null) {
            this.xml().removeElement(oldActivity.xml());
        }
        this.addActivity(newActivity);
    }

    @Override
    public Iterable<GpelActivity> activities() {
        Iterable<GpelActivity> giterable = new Iterable<GpelActivity>(){

            @Override
            public Iterator<GpelActivity> iterator() {
                return new Iterator<GpelActivity>(){
                    GpelActivity currentActivity;
                    {
                        this.currentActivity = GpelContainerActivityOfOne.this.oneActivity();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentActivity != null;
                    }

                    @Override
                    public GpelActivity next() {
                        if (this.currentActivity == null) {
                            throw new IllegalStateException();
                        }
                        GpelActivity a = this.currentActivity;
                        this.currentActivity = null;
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("not allowed to remove");
                    }
                };
            }
        };
        return giterable;
    }
}

