/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gpel.GpelConstants;
import org.gpel.logger.GLogger;
import org.gpel.model.GpelModelException;
import org.gpel.model.GpelProcess;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlInfosetBuilder;

public class GpelResolver {
    private static final GLogger logger = GLogger.getLogger();
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private static final GpelResolver instance = new GpelResolver();
    protected Map ns2Gpel = new HashMap();
    protected Map location2Gpel = new HashMap();

    GpelResolver() {
    }

    public static GpelResolver getInstance() throws GpelModelException {
        return instance;
    }

    public GpelProcess loadGpel(URI url) throws GpelModelException {
        return this.loadGpel(null, url, false);
    }

    public GpelProcess loadGpel(URI base, URI url) throws GpelModelException {
        return this.loadGpel(base, url, false);
    }

    public GpelProcess loadGpel(URI base, URI location, boolean useCache) throws GpelModelException {
        GpelProcess process;
        Object hit;
        if (useCache && (hit = this.location2Gpel.get(location)) != null) {
            return (GpelProcess)hit;
        }
        try {
            URI uri = base != null ? base.resolve(location) : location;
            URL url = uri.toURL();
            URLConnection conn = url.openConnection();
            XmlDocument doc = builder.parseInputStream(conn.getInputStream(), conn.getContentEncoding());
            process = new GpelProcess(doc.getDocumentElement());
        }
        catch (IOException e) {
            throw new GpelModelException("could not load GPEL from " + location, e);
        }
        this.location2Gpel.put(location, process);
        this.ns2Gpel.put(process.getTargetNamespace(), process);
        return process;
    }

    public GpelProcess loadGpel(Class referenceClassForLoading, String gpelLoc) {
        GpelProcess process;
        URI gpelLoclUri;
        URI base = new File(".").toURI();
        try {
            gpelLoclUri = new URI(gpelLoc);
        }
        catch (URISyntaxException e) {
            throw new GpelModelException("location of WSDL must be correct URI, could not parse '" + gpelLoc + "'", e);
        }
        try {
            process = this.loadGpel(base, gpelLoclUri);
        }
        catch (GpelModelException we) {
            Throwable t = we.getCause();
            if (t instanceof FileNotFoundException) {
                try {
                    URL gpelOnClassPath;
                    String locationOnClassapth = gpelLoc;
                    if (gpelLoc.charAt(0) != '/') {
                        locationOnClassapth = '/' + locationOnClassapth;
                    }
                    if ((gpelOnClassPath = referenceClassForLoading.getResource(locationOnClassapth)) == null) {
                        throw we;
                    }
                    URI uri = URI.create(gpelOnClassPath.toString());
                    process = this.loadGpel(null, uri);
                }
                catch (GpelModelException e) {
                    throw we;
                }
                catch (IllegalArgumentException e) {
                    throw we;
                }
            }
            throw we;
        }
        return process;
    }

    public GpelProcess resolveImport(String namespace, URI base, URI optionalLocation) throws GpelModelException {
        Object hit = this.ns2Gpel.get(namespace);
        if (hit != null) {
            return (GpelProcess)hit;
        }
        if (optionalLocation != null) {
            return this.loadGpel(base, optionalLocation, true);
        }
        throw new GpelModelException("could not resolve import for namespace " + namespace + " with location " + optionalLocation);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append("={");
        buf.append("List of namespaces in resolver cache=");
        Iterator i = this.ns2Gpel.keySet().iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (!i.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }
}

