/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.model;

import java.util.Iterator;
import org.gpel.GpelConstants;
import org.gpel.model.GpelModelBase;
import org.gpel.model.GpelModelValidationException;
import org.gpel.model.GpelVariable;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public class GpelVariablesContainer
extends GpelModelBase {
    public static final String TYPE_NAME = "variables";

    public GpelVariablesContainer(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelVariablesContainer(XmlNamespace NS) {
        super(NS, TYPE_NAME);
    }

    public void addVariable(GpelVariable variable) throws GpelModelValidationException {
        this.xml().addElement(variable.xml());
    }

    public Iterable<GpelVariable> variables() {
        final Iterator elContent = this.xml().requiredElementContent().iterator();
        Iterable<GpelVariable> giterable = new Iterable<GpelVariable>(){

            @Override
            public Iterator<GpelVariable> iterator() {
                return new Iterator<GpelVariable>(){

                    @Override
                    public boolean hasNext() {
                        return elContent.hasNext();
                    }

                    @Override
                    public GpelVariable next() {
                        XmlElement el = (XmlElement)elContent.next();
                        GpelVariable variable = (GpelVariable)el.viewAs(GpelVariable.class);
                        return variable;
                    }

                    @Override
                    public void remove() {
                        elContent.remove();
                    }
                };
            }
        };
        return giterable;
    }

    public void validateModel() throws GpelModelValidationException {
        String name = this.xml().getName();
        if (!name.equals(TYPE_NAME)) {
            throw new GpelModelValidationException("expected variables but got " + name);
        }
        XmlNamespace ns = this.xml().getNamespace();
        if (!GpelConstants.BPEL_NS.equals(ns) || !GpelConstants.GPEL_NS.equals(ns)) {
            throw new GpelModelValidationException("process must be in " + GpelConstants.BPEL_NS + " or " + GpelConstants.GPEL_NS + " and not " + ns.getName());
        }
    }
}

