/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.xml;

import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlElementView;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.TypedXmlElementView;
import org.xmlpull.infoset.view.XmlValidationException;

public abstract class GpelXmlViewBase
extends TypedXmlElementView {
    protected static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    protected static XmlNamespace NS;
    private final String typeName;

    public GpelXmlViewBase(String typeName, XmlElement target) {
        super(target);
        this.typeName = typeName;
    }

    public GpelXmlViewBase(XmlNamespace ns, String typeName) {
        super(builder.newFragment(ns, typeName));
        if (NS != null) {
            if (!NS.equals(ns)) {
                throw new XmlValidationException("element must be in " + NS + " and not " + ns.getName());
            }
        } else {
            NS = ns;
        }
        this.xml().addView((XmlElementView)this);
        this.typeName = typeName;
    }

    public XmlNamespace xmlTypeNs() {
        return NS;
    }

    public String xmlTypeName() {
        return this.typeName;
    }

    protected void checkNamespaceAndName() throws XmlValidationException {
        String name = this.xml.getName();
        if (this.typeName != null && !name.equals(this.typeName)) {
            throw new XmlValidationException("expected " + this.typeName + " but got " + name);
        }
        XmlNamespace ns = this.xml.getNamespace();
        if (!NS.equals(ns)) {
            throw new XmlValidationException("element must be in " + NS + " and not " + ns.getName());
        }
    }

    public String xmlString() {
        String s = builder.serializeToString((Object)this.xml);
        return s;
    }

    public String xmlStringPretty() {
        String s = builder.serializeToStringPretty((Object)this.xml);
        return s;
    }

    public String toString() {
        return this.xmlString();
    }
}

