/* -*-             c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
//for license please see accompanying LICENSE.txt file (available also at http://www.xmlpull.org/)
package org.xmlpull.infoset;

//import java.util.Iterator;

//use QName

/**
 * Represents
 * <a href="http://www.w3.org/TR/xml-infoset/#infoitem.element">Element Information Item</a>
 * except for in-scope namespaces that can be reconstructed by visiting this element parent,
 * checking its namespaces, then grandparent and so on. For convenience there are
 * methods to resolve namespace prefix for given namespace name.
 *
 * <br />NOTE: this representaiton is optimized for streaming - iterator approach that
 * allows gradual visiting of nodes is preferred over indexed access.
 *
 * @version $Revision: 1.8 $
 * @author <a href="http://www.extreme.indiana.edu/~aslom/">Aleksander Slominski</a>
 */
public interface XmlElement extends XmlElementReadOnly, XmlContainer, XmlContained, Cloneable {
    public static final String NO_NAMESPACE = "";

    //public XmlElement test();
    
    //JDK15 covariant public XmlElement clone() throws CloneNotSupportedException
    /**
     * Method clone
     *
     * @return   an Object
     *
     * @exception   CloneNotSupportedException
     *
     */
    public XmlElement clone() throws CloneNotSupportedException;
    
    
    /**
     * XML Infoset [base URI] property
     *
     * @param    baseUri             a  String
     *
     */
    public void setBaseUri(String baseUri);
    
    
    /**
     * Method setParent
     *
     * @param    parent              a  XmlContainer
     *
     */
    public void setParent(XmlContainer parent);
    
    /**
     * Set namespace ot use for theis element.
     * Note: namespace prefix is <b>always</b> ignored.
     */
    public void setNamespace(XmlNamespace namespace);
    
    /**
     * XML Infoset [local name] property.
     *
     * @param    name                a  String
     *
     */
    public void setName(String name);
        
    //----------------------------------------------------------------------------------------------
    // Attributes management
    
    public XmlElement setAttribute(XmlAttribute attributeToSet);

    /**
     * Set attribute name to string value. If value is null attribute is deleted.
     */
    public XmlElement setAttributeValue(String name, String value);
    
    /**
     * Set attribute wih given namespace and name to string value.
     * If value is null attribute is deleted.
     */
    public XmlElement setAttributeValue(XmlNamespace  namespace, String name, String value);
    
    public XmlElement setAttribute(String type, XmlNamespace namespace,
                                     String name, String value);
    public XmlElement setAttribute(String type, XmlNamespace namespace,
                                     String name, String value, boolean specified);
    public XmlElement setAttribute(String attributeType,
                                     String attributePrefix,
                                     String attributeNamespace,
                                     String attributeName,
                                     String attributeValue,
                                     boolean specified);
    
    /**
     * Method ensureAttributeCapacity is only a hint -
     * it may help to optimize attribute storage to extexted number of attributes.
     *
     * @param    minCapacity         an int
     *
     */
    public void ensureAttributesCapacity(int minCapacity) ;
    
    
    
//    /**
//     * Find attribute that matches given name or namespace
//     * Returns null if not found.
//     * NOTE: if namespace is null in this case it will match only
//     * attributes that has no namespace.
//     * @deprecated Use attribute()
//     */
//    public XmlAttribute findAttribute(String attributeNamespaceName,
//                                      String attributeName);
    
    
    /**
     * Method removeAttribute
     *
     * @param    attr                a  XmlAttribute
     *
     */
    public void removeAttribute(XmlAttribute attr);
    
    /**
     * Method removeAllAttributes
     *
     */
    public void removeAllAttributes();




    //----------------------------------------------------------------------------------------------
    // Namespaces management
    
    /**
     * Create new namespace with prefix and namespace name
     * (both MUST NOT be null or exception is throws)
     * and add it to current element.
     */
    public XmlNamespace declareNamespace(String prefix, String namespaceName) throws XmlBuilderException;
    
    /**
     * Add namespace to current element (if namespace is null then exception is thrown)
     */
    public XmlNamespace declareNamespace(XmlNamespace namespace) throws XmlBuilderException;
    
    /**
     * This is just a hint to OM to allow optimize to storage for given number of namespaces.
     * OM implemenentation may ignore it...
     */
    public void ensureNamespaceDeclarationsCapacity(int minCapacity) throws XmlBuilderException;
    
    /**
     * Create new namespace with null prefix.
     * If namespace name is null then throws exception.
     */
    public XmlNamespace newNamespace(String namespaceName) throws XmlBuilderException;
    
    /**
     * Create new namespace with prefix and namespace name
     * (both MUST NOT be null or exception is thrown).
     */
    public XmlNamespace newNamespace(String prefix, String namespaceName) throws XmlBuilderException;
    
    /**
     * Remove all namespace declarations from current element.
     */
    public void removeAllNamespaceDeclarations() throws XmlBuilderException;
    
    
    //----------------------------------------------------------------------------------------------
    // Children management (element content)
    
    /**
     * NOTE: =child added is _not_ checked if it XmlContainer, caller must manually fix
     * parent in child by calling setParent() !!!!
     */
    public void addChild(Object child);
    /**
     * Method addChild
     *
     * @param    pos                 an int
     * @param    child               an Object
     *
     */
    public void addChild(int pos, Object child);
    
    /**
     * NOTE: the child element must unattached to be added
     * (it is atttached if it is XmlContainer of recognized type and getParent() != null)
     */
    public XmlElement addElement(XmlElement el);
    /**
     * Method addElement
     *
     * @param    pos                 an int
     * @param    child               a  XmlElement
     *
     * @return   a XmlElement
     *
     */
    public XmlElement addElement(int pos, XmlElement child);
    
    /**
     * Method addElement
     *
     * @param    name                a  String
     *
     * @return   a XmlElement
     *
     */
    public XmlElement addElement(String name);
    /**
     * Method addElement
     *
     * @param    namespace           a  XmlNamespace
     * @param    name                a  String
     *
     * @return   a XmlElement
     *
     */
    public XmlElement addElement(XmlNamespace namespace, String name);

    /**
     * Method addComment
     *
     * @param    content                a  String
     *
     * @return   an XmlComment
     *
     */
    public XmlComment addComment(String content);
    
    /**
     * Method ensureChildrenCapacity
     *
     * @param    minCapacity         an int
     *
     */
    public void ensureChildrenCapacity(int minCapacity);
    
//    /**
//     * @deprecated see element()
//     */
//    public XmlElement findElementByName(String name);
//    /**
//     * @deprecated see element()
//     */
//    public XmlElement findElementByName(String namespaceName, String name);
//    /**
//     * @deprecated see elements()
//     */
//    public XmlElement findElementByName(String name,
//                                        XmlElement elementToStartLooking);
//    /**
//     * @deprecated see elements()
//     */
//    public XmlElement findElementByName(String namespaceName, String name,
//                                        XmlElement elementToStartLooking);
    
    
    public void insertChild(int pos, Object childToInsert);
    
    /**
     * Create unattached element
     */
    public XmlElement newElement(String name);

    /**
     * Method newElement
     *
     * @param    namespace           a  XmlNamespace
     * @param    name                a  String
     *
     * @return   a XmlElement
     *
     */
    public XmlElement newElement(XmlNamespace namespace, String name);
    /**
     * Method newElement
     *
     * @param    namespaceName       a  String
     * @param    name                a  String
     *
     * @return   a XmlElement
     *
     */
    public XmlElement newElement(String namespaceName, String name);
    
    /**
     * Method newComment
     *
     * @param    content                a  String
     *
     * @return   an XmlComment
     *
     */
    public XmlComment newComment(String content);

    /**
     * Removes all children - every child that was
     * implementing XmlNode will have set parent to null.
     */
    public void removeAllChildren();
    
    /**
     * Method removeChild
     *
     * @param    child               an Object
     *
     */
    public void removeChild(Object child);
    
    public void removeElement(XmlElement el);
    
    /**
     * Method replaceChild.
     * <br/>NOTE: parent of old and new child is not modified!
     *
     * @param    newChild            an Object
     * @param    oldChild            an Object
     *
     */
    public void replaceChild(Object newChild, Object oldChild);
    
    
    /**
     * Method replaceElement works similiar to replaceChild but will set oldElement
     * parent to null and make newElement parent to be this element.
     *
     * @param    newElement          a  XmlElement
     * @param    oldElement          a  XmlElement
     *
     */
    public void replaceElement(XmlElement newElement, XmlElement oldElement);
        
    /**
     * Replace all elements (if any) with the same namespace and name as the new element.
     */
    public void replaceLikeElementsWith(XmlElement element);
    
    //public void remove(int pos);
    //public void set(int index, Object child);
    
    /**
     * Remove all children and then add this text as only child.
     */
    public void setText(String textContent);
    //public void replaceChildrenWithText(String textContent);
    
    //public Iterable elementsContent();
    //public Iterable elementsContent(String name);
    //public Iterable elementsContent(XmlNamespace n String name);
    
    //String text() //children must map to text only nodes!!!
    //public String requiredTextContent();
    
    
    //selectNodes(String xpath)
    
    //public XmlNamespace getNamespacePrefix(String namespaceName, boolean generate)
    //public XmlNamespace findNamespace(String prefix, String namespace)
    
    /** it may need to reconsruct whole subtree to get count ... */
    //public int getChildrenCount();
    
    //public Object getFirstChild() throws XmlPullParserException;
    //public Object getNextSibling() throws XmlPullParserException;
    
    //public Object getChildByName(String namespace, String name);
    
//TODO add method requiredAttribute( "id" );
//TODO add method requiredAttributeValue( "id" );
//TODO add XmlElement requiredFirstElement() in Adapter?
//TODO add XmlElement requiredOneElement() in AdpateR?
    
}

