/* -*-             c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
//for license please see accompanying LICENSE.txt file (available also at http://www.xmlpull.org/)
package org.xmlpull.infoset;

//import java.util.Iterator;


/**
 * Represents
 * <a href="http://www.w3.org/TR/xml-infoset/#infoitem.element">Element Information Item</a>
 * that supports read-only operations (handy to use compiler checking that element is not modified).
 *
 * @version $Revision: 1.7 $
 * @author <a href="http://www.extreme.indiana.edu/~aslom/">Aleksander Slominski</a>
 */
public interface XmlElementReadOnly extends XmlContainer {
    
    //----------------------------------------------------------------------------------------------
    // Element properties
    
    /**
     * XML Infoset [base URI] property
     *
     * @return   a String
     *
     */
    public String getBaseUri();
    
    /**
     * Get top most container that is either XmlDocument or XmlElement (may be event this element!!!)
     */
    public XmlContainer getRoot();
    
    /**
     * XML Infoset [parent] property.
     * If current element is not child of containing parent XmlElement or XmlDocument
     * then builder exception will be thrown
     */
    public XmlContainer getParent() throws XmlBuilderException;
    
    /**
     * Return namespace of current element
     * (XML Infoset [namespace name] and [prefix] properties combined)
     * null is only returned if
     * element was created without namespace
     * */
    public XmlNamespace getNamespace();
    
    /**
     * Return namespace name (XML Infoset [namespace name]property
     * or null if element has no namespace
     */
    public String getNamespaceName();
    
    /**
     * XML Infoset [local name] property.
     *
     * @return   a String
     *
     */
    public String getName();
    
    //----------------------------------------------------------------------------------------------
    // Attributes management
    
    
    /**
     * Return Iterator<XmlAttribute> - null is never returned if there is no children
     * then iteraotr over empty collection is returned
     */
    public Iterable<XmlAttribute> attributes();
    
    /**
     * Method hasAttributes
     *
     * @return   a boolean
     *
     */
    public boolean hasAttributes();
    
    
//    /**
//     * Get attribute value
//     *
//     * @param    attribute namespace (may be null for attributes that has no namespace)
//     * @param    attributeName       a  String
//     *
//     * @return   a String
//     *
//     */
//    public String attributeValue(String attributeNamespaceName,
//                                 String attributeName);
    
    /**
     * Find attribute that matches given name or namespace
     * Returns null if not found.
     * Will match only attribute that have no namesapce.
     */
    public XmlAttribute attribute(String attributeName);
    
    /**
     * Find attribute that matches given name or namespace
     * Returns null if not found.
     * NOTE: if namespace is null in this case it will match only
     * attributes that have no namespace.
     *
     */
    public XmlAttribute attribute(XmlNamespace attributeNamespaceName,
                                  String attributeName);
    
    
    /**
     * Find attribute that matches given name or namespace
     * Throws XmlBuilderException if not found.
     * Will match only attribute that have no namesapce.
     */
    public XmlAttribute requiredAttribute(String attributeName) throws XmlBuilderException;
    
    /**
     * Find attribute that matches given name or namespace
     * Throws XmlBuilderException if not found.
     * NOTE: if namespace is null in this case it will match only
     * attributes that have no namespace.
     *
     */
    public XmlAttribute requiredAttribute(XmlNamespace attributeNamespaceName,
                                          String attributeName) throws XmlBuilderException;
    
    /**
     * Get attribute value or null if no attribute found.
     *
     * @param    attributeName       a  String
     *
     * @return   a String
     *
     */
    public String attributeValue(String attributeName);
    
    /**
     * Get attribute value or null if not attribute found.
     *
     * @param    attribute namespace (may be null for attributes that has no namespace)
     * @param    attribute name
     *
     * @return   a String
     *
     */
    public String attributeValue(XmlNamespace attributeNamespace,
                                 String attributeName);
    
    /**
     * Get attribute value or throw exception if not found or throw exception if not found.
     *
     * @param    attributeName       a  String
     *
     * @return   a String
     *
     */
    public String requiredAttributeValue(String attributeName) throws XmlBuilderException;
    
    /**
     * Get attribute value
     *
     * @param    attribute namespace (may be null for attributes that has no namespace)
     * @param    attribute name
     *
     * @return   a String
     *
     */
    public String requiredAttributeValue(XmlNamespace attributeNamespace,
                                         String attributeName)  throws XmlBuilderException;
    
    
    
    //----------------------------------------------------------------------------------------------
    // Namespaces management
    
    //JDK15 Iterable
    /**
     * Return iteraotr for all namespaces in current element only.
     * NOTE: if there is no namespaces
     * then empty iterator is returned (null is never returned)
     */
    public Iterable<XmlNamespace> namespaces();
    //public Iterator<XmlNamespace> namespaces();
    
    /**
     * Return true if element has namespace declarations.
     */
    public boolean hasNamespaceDeclarations();
    
    /**
     * Find namespace (will have non empty prefix or empty prefix for default NS)
     * corresponding to namespace prefix
     * checking first current element and if not found continue in parent (if element has parent)
     * and so on.
     */
    public XmlNamespace lookupNamespaceByPrefix(String namespacePrefix);
    
    /**
     * Find namespace (will have non empty prefix) corresponding to namespace name
     * checking first current elemen and if not found continue in parent (if element has parent).
     * and so on.
     */
    public XmlNamespace lookupNamespaceByName(String namespaceName);
    
    
    
    //----------------------------------------------------------------------------------------------
    // Children management (element content)
    
    //JDK15 Iterable
    /** Return Iterator<Object>  - null is never returned if there is no children
     then iteraotr over empty collection is returned */
    public Iterable children();
    
    /**
     * Method hasChildren
     *
     * @return   a boolean
     *
     */
    public boolean hasChildren();
    
    /**
     * Method hasChild
     *
     * @param    child               an Object
     *
     * @return   a boolean
     *
     */
    public boolean hasChild(Object child);
    
    /**
     * return element at position (0..count-1) or IndexOutOfBoundsException if positon incorrect
     */
    public XmlElement element(int position);
    
    //int count()
    //int countElement()
    //XmlElement element(String name) //return first element matching, null if not found!
    /**
     * call element(name) and if null was returned throw XmlBuilderException
     */
    public XmlElement requiredElement(String name)  throws XmlBuilderException;
    
    /**
     * find first element with name and namespace (namespace is ignored in search)
     * */
    public XmlElement element(String name);
    
    /**
     * call element(n, name) and if null was returned throw XmlBuilderException
     */
    public XmlElement requiredElement(XmlNamespace n, String name)  throws XmlBuilderException;
    
    /**
     * find first element with name and namespace (if namespace is null it is ignored in search)
     * */
    public XmlElement element(XmlNamespace n, String name);
    /**
     * find first element with name and namespace (if namespace is null it is ignored in search)
     * if no matching element is found then new element is created, appended to children, and returned
     * */
    public XmlElement element(XmlNamespace n, String name, boolean create);
    //Iterable elements(String name);
    //Iterable elements(XmlNamespace n, String name);
    
    /** Return all elements that has namespace and name (null is never returned but empty iterable) */
    public Iterable<XmlElement> elements(XmlNamespace n, String name);
    
    //public XmlElementReadOnly test();
    
    //----------------------------------------------------------------------------------------------
    // Utility methods to make manipulating Infoset easier for typical use cases
    //JDK15 Iterable
    /** Return iterable that over element children (ignore white spaces) or
     * exception if non white space children are found
     * (as expected no mixed content!).
     */
    public Iterable<XmlElement> requiredElementContent();
    
    /**return children content as text - if there are any no text children throw exception  */
    public String requiredText() throws XmlBuilderException;
    //public String requiredTextContent();
    
    
    
    //----------------------------------
    //Multiple views
    public <T extends XmlElementView> T viewAs(Class<T> someViewClass) throws XmlBuilderException;
    
    public void addView(XmlElementView newView) throws XmlBuilderException;

    /**
     * Return all elements that has namespace and name (null is never returned but empty interable)
     * and casts its element to passed view
     * */
    public <T extends XmlElementView> Iterable<T> elements(XmlNamespace n, String name, Class<T> someViewClass);
    
}

