/* -*-             c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
//for license please see accompanying LICENSE.txt file (available also at http://www.xmlpull.org/)
package org.xmlpull.infoset;


/**
 * Represents
 * <a href="http://www.w3.org/TR/xml-infoset/#infoitem.namespace">Namespace Information Item</a>
 * .
 *
 * @version $Revision: 1.1 $
 * @author <a href="http://www.extreme.indiana.edu/~aslom/">Aleksander Slominski</a>
 */
public interface XmlNamespace
{
    /**
     * [Prefix] can be null.
     * In this case it will be looked up from XML tree and used if available
     * otherwise it will be automatically created only for serializaiton.
     * <br /> TODO: If prefix is empty string it will be used to indicate default namespace.
     */
    public String getPrefix();

    /**
     * [Namespace name] is never null.
     * Only allowed to be empty string if prefix is also empty string
     * (used to undeclare default namespace)
     */
    public String getName();

}

