/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the licence.
 *
 * $Id: XmlQNameAttribute.java,v 1.3 2006/05/02 01:38:04 aslom Exp $
 */
package org.xmlpull.infoset.ext;

import javax.xml.namespace.QName;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.impl.XmlAttributeImpl;

//DONE: move to XPP5 package so it can be shared between XSUL5 and GPEL and not duplicated ...

/**
 * Implementation of an attribute that keeps QName as value
 * (to resolve namespace prefix it must be bound to owner element).
 * */
public class XmlQNameAttribute extends XmlAttributeImpl {
    private QName qnameAttrValue_;
    private boolean isValueCached;
    private String cachedValue;

    //NOTE: this is *not* used by XmlElementImpl
    public Object clone() throws CloneNotSupportedException {
        XmlQNameAttribute cloned = (XmlQNameAttribute) super.clone();
        cloned.qnameAttrValue_ = qnameAttrValue_;
        return cloned;
    }

    public XmlQNameAttribute(XmlElement owner, XmlNamespace namespace,
                             String name, QName qnameAttrValue) {
        // gotta to love Java ctors ...
        super(owner, namespace, name, "<NO VALUE - YOU SHOULD NEVER SEE IT - SOMETHING IS WRONG!>");
        //            owner.lookupNamespaceByPrefix(
        //                qnameAttrValue.getPrefix()).getPrefix()
        //                + ':'
        //                + qnameAttrValue.getLocalPart());
        //qnameAttrValue.getPrefix() + ':' + qnameAttrValue.getLocalPart()
        this.qnameAttrValue_ = qnameAttrValue;
    }

    //COPY constructor
    public XmlQNameAttribute(XmlElement owner, XmlAttribute attr) {
        super(owner,
              attr.getType(), attr.getNamespace(), attr.getName(), attr.getValue(),
              attr.isSpecified());
        if (owner == null) throw new IllegalArgumentException();
        if (attr.getOwner() != null && owner != attr.getOwner()) throw new IllegalArgumentException("owner");
        // convert value into qname
        String value = attr.getValue();
        int colonPos = value.lastIndexOf(':');
        String localPart = value.substring(colonPos + 1); //OK even if colonPos == -1
        String prefix;
        if (colonPos != -1) {
            prefix = value.substring(0, colonPos);
        } else {
            prefix = "";
        }
        XmlNamespace ns = owner.lookupNamespaceByPrefix(prefix);
        if (ns == null) {
            throw new XmlBuilderException("could not find namespace with prefix " + prefix
                                          + " for attribute " + attr + " in " + owner);
        }
        qnameAttrValue_ = new QName(ns.getName(), localPart, prefix);
    }

    //    public String getValue() {
    //        return qnameAttrValue_.getLocalPart() + ':' + qnameAttrValue_.getLocalPart();
    //    }

    public QName getValueAsQName() {
        return qnameAttrValue_;
    }

    public String getValue() {
        if (!isValueCached) {
            String prefix = qnameAttrValue_.getPrefix();
            String uri = qnameAttrValue_.getNamespaceURI();
            XmlElement owner = getOwner();
            XmlNamespace ns = null;
            // check that prefix in Qname corresponds ot the same namespace in XmlElement context
            if (prefix != null && prefix.length() > 0) { //by defaul QName sets prefix to "" -- bad!
                ns = owner.lookupNamespaceByPrefix(prefix);
                if (ns == null) {
                    throw new XmlBuilderException(
                        "can not get namespace for prefix '" + prefix + "' for Qname attribute "
                        + " '" + getName() + "' with value " + qnameAttrValue_
                        + " in element {" + owner.getNamespaceName() + "}" + owner.getName());
                }
                if (ns.getName().equals(uri)) {
                    ns = null;
                }
            }
            if (ns == null) {
                // second try -- ignore whatever prefix was in QName passed by user ..
                ns = getOwner().lookupNamespaceByName(uri);
                if (ns != null) {
                    prefix = ns.getPrefix();
                } else {
                    prefix = null;
                }
                if (prefix == null) {
                    // need to delcare namespace
                    int i = 1;
                    while (true) {
                        prefix = "n" + (i++);
                        ns = getOwner().lookupNamespaceByPrefix(prefix);
                        if (ns == null) {
                            ns = getOwner().declareNamespace(prefix, uri);
                            break;
                        }
                    }
                    prefix = ns.getPrefix();
                }
            }
            assert prefix != null; //lot of ado about (amost) nothing
            if (prefix.length() > 0) {
                cachedValue = prefix + ':' + qnameAttrValue_.getLocalPart();
            } else {
                cachedValue =  qnameAttrValue_.getLocalPart();
            }

        }
        return cachedValue;
    }


}

/*
* Indiana University Extreme! Lab Software License, Version 1.2
*
* Copyright (c) 2004-2005 The Trustees of Indiana University.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
* 1) All redistributions of source code must retain the above
*    copyright notice, the list of authors in the original source
*    code, this list of conditions and the disclaimer listed in this
*    license;
*
* 2) All redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the disclaimer
*    listed in this license in the documentation and/or other
*    materials provided with the distribution;
*
* 3) Any documentation included with all redistributions must include
*    the following acknowledgement:
*
*      "This product includes software developed by the Indiana
*      University Extreme! Lab.  For further information please visit
*      http://www.extreme.indiana.edu/"
*
*    Alternatively, this acknowledgment may appear in the software
*    itself, and wherever such third-party acknowledgments normally
*    appear.
*
* 4) The name "Indiana University" or "Indiana University
*    Extreme! Lab" shall not be used to endorse or promote
*    products derived from this software without prior written
*    permission from Indiana University.  For written permission,
*    please contact http://www.extreme.indiana.edu/.
*
* 5) Products derived from this software may not use "Indiana
*    University" name nor may "Indiana University" appear in their name,
*    without prior written permission of the Indiana University.
*
* Indiana University provides no reassurances that the source code
* provided does not infringe the patent or any other intellectual
* property rights of any other entity.  Indiana University disclaims any
* liability to any recipient for claims brought by any other entity
* based on infringement of intellectual property rights or otherwise.
*
* LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
* NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
* UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
* SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
* OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
* SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
* DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
* RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
* AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
* SOFTWARE.
*/
