package org.xmlpull.infoset.view;

import javax.xml.namespace.QName;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlElementView;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.ext.XmlQNameAttribute;

/**
 * Classes that extends this abstract class provide a typed view on a referenced XML Element.
 * Typing is provided by requiring namespace and name of the element and providing
 * hooks to validate element content.
 */

public abstract class TypedXmlElementView implements XmlElementView {
    //    private final static XmlInfosetBuilder builder = XmlInfosetBuilder.newInstance();
    protected XmlElement xml;
    
    public TypedXmlElementView(XmlElement el) {
        this.xml = el;
        xml().addView(this);
        checkNamespaceAndName();
    }
    
    //    public TypedXmlElementView(XmlNamespace ns, String typeName) {
    //        this(builder.newFragment(ns, typeName));
    //      xml().addView(this);
    //    }
    public XmlElement xml() {
        return xml;
    }
    
    public abstract XmlNamespace xmlTypeNs();
    public abstract String xmlTypeName();
    
    protected void checkNamespaceAndName() throws XmlValidationException {
        if (!xml.getNamespace().equals(xmlTypeNs())) {
            throw new XmlValidationException(
                "element must be in '" + xmlTypeNs()  + "'" +
                " and not '" + xml.getNamespace().getName()+"'");
        }
        if (!xml.getName().equals(xmlTypeName())) {
            throw new XmlValidationException(
                "expected " + xmlTypeName() + " but got " + xml.getName());
        }
    }
    
    //convenience method
    public <T extends XmlElementView> T xmlViewAs(Class<T> someViewClass) throws XmlBuilderException {
        return xml().viewAs(someViewClass);
    }

    protected void xmlSetAttributeQNameValue(String name, QName nameValue) {
        if (nameValue == null) {
            XmlAttribute oldAttribute = xml.attribute(name);
            if (oldAttribute != null) {
                xml.removeAttribute(oldAttribute);
            }
            return;
        }
        xmlSetRequiredAttributeQNameValue(name, nameValue);
    }
    
    protected void xmlSetRequiredAttributeQNameValue(String name, QName nameValue) {
        if (nameValue == null) {
            throw new XmlValidationException(
                "attribute " + name + " is required to have value"
                + " in element " + xmlCuteElName());
        }
        XmlQNameAttribute aa =  new XmlQNameAttribute(xml(), (XmlNamespace)null, name, nameValue);
        //String value =
        xml.setAttribute(aa);
    }
    
    protected QName xmlRequireAttributeQNameValue(String name) throws XmlValidationException {
        QName q = xmlGetAttributeQNameValue(name);
        if (q == null) {
            throw new XmlValidationException("required attribute " + name + " is missing from element "
                                             + xmlCuteElName());
        }
        return q;
    }
    
    
    protected QName xmlGetAttributeQNameValue(String name) {
        XmlAttribute aa = xml.attribute(name);
        if (aa == null) {
            return null;
        }
        if (aa instanceof XmlQNameAttribute) {
            return ((XmlQNameAttribute)aa).getValueAsQName();
        }
        XmlQNameAttribute qa = new XmlQNameAttribute(xml(), aa);
        xml.removeAttribute(aa);
        xml.setAttribute(qa);
        return qa.getValueAsQName();
    }
    
    protected void xmlSetRequiredAttributeNcNameValue(String name, String  ncNameValue) {
        if (ncNameValue == null) {
            throw new XmlValidationException(
                "attribute " + name + " is required ot have value"
                + " in element " + xmlCuteElName());
            
        }
        if (ncNameValue.indexOf(':') != -1) {
            throw new IllegalArgumentException(
                "NcName attribute " + name + " value can not have double colon (':')"
                + " but got '" + ncNameValue + "'"
                + " in element " + xmlCuteElName());
        }
        //String value =
        xml.setAttributeValue(name, ncNameValue);
    }
    
    protected void xmlSetAttributeNcNameValue(String name, String  ncNameValue) {
        if (ncNameValue == null) { //remove
            XmlAttribute attr = xml.attribute(name);
            if (attr != null) {
                xml.removeAttribute(attr);
            }
            return;
        }
        xmlSetRequiredAttributeNcNameValue(name, ncNameValue);
    }
    
    protected String xmlRequireAttributeNcNameValue(String name) throws XmlValidationException {
        String s = xmlGetAttributeNcNameValue(name);
        if (s == null) {
            throw new XmlValidationException("required attribute " + name + " is missing from "
                                             + xmlCuteElName());
        }
        return s;
    }
    
    protected String xmlGetAttributeNcNameValue(String name) {
        String ncNameValue = xml.attributeValue(name);
        if (ncNameValue != null) {
            if (ncNameValue.indexOf(':') != -1) {
                throw new IllegalArgumentException(
                    "NcName attribute value can not have double colon (':')but got '" + ncNameValue + "'"
                    + " in " + xmlCuteElName());
            }
        }
        return ncNameValue;
    }
    
    protected String xmlCuteElName() {
        return "{" + xml().getNamespaceName() + "}" + xml().getName();
    }
    
    public void xmlValidate() throws XmlValidationException {
        checkNamespaceAndName();
    }

    
}

