/* -*-             c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
//for license please see accompanying LICENSE.txt file (available also at http://www.xmlpull.org/)
package org.xmlpull.infoset.wrapper;

//import java.util.IdentityHashMap;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.XmlElement;

/**
 * Wraps XML attribute - allows overriding and other nice things.
 */
public class XmlAttributeAdapter implements XmlAttribute
{
    private XmlAttribute target;
    
    public XmlAttributeAdapter(XmlAttribute target) {
        this.target = target;
    }
    
    //JDK15 covariant public XmlElementAdapter clone() throws CloneNotSupportedException;
    public Object clone() throws CloneNotSupportedException {
        XmlAttributeAdapter ela = (XmlAttributeAdapter) super.clone();
        ela.target = (XmlAttribute) target.clone();
        return ela;
    }    
    
    public XmlElement getOwner() {
        return target.getOwner();
    }
    
    public String getNamespaceName() {
        return target.getNamespaceName();
    }
    
    public XmlNamespace getNamespace() {
        return target.getNamespace();
    }
    
    public String getName() {
        return target.getName();
    }
    
    public String getValue() {
        return target.getValue();
    }
    
    public String getType() {
        return target.getType();
    }
    
    public boolean isSpecified() {
        return target.isSpecified();
    }
    
//    public void serialize(XmlSerializer ser) throws IOException {
//      // TODO
//    }
}

