/**
 * Copyright 2011-2018 Fraunhofer-Gesellschaft zur Förderung der angewandten Wissenschaften e.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ogema.driverconfig;

import org.json.JSONArray;
import org.json.JSONObject;

public interface HLDriverInterface {
	public JSONObject readChannel(String interfaceId, String deviceAddress, String channelAddress);

	public void createChannel(String interfaceId, String deviceAddress, String channelAddress, long timeout,
			String resourceName, String deviceId);

	public void writeChannel(String interfaceId, String deviceAddress, String channelAddress, String writeValue);

	public void deleteChannel(String interfaceId, String deviceAddress, String channelAddress);

	public JSONArray showCreatedChannels(String deviceAddress);

	public String whichID();
}
