/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.device_conf;

import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.ogema.apps.device_conf.Servlet;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.security.WebAccessManager;
import org.ogema.driverconfig.HLDriverInterface;
import org.ogema.driverconfig.LLDriverInterface;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DeviceConfigurator
implements Application {
    private BundleContext context;
    private ServiceTracker<HLDriverInterface, HLDriverInterface> hl_tracker;
    private ServiceTracker<LLDriverInterface, LLDriverInterface> ll_tracker;
    private HashMap<String, HLDriverInterface> hl_map;
    private HashMap<String, LLDriverInterface> ll_map;
    JSONArray not_available_json;
    JSONObject not_available_json_object;
    private WebAccessManager wam;

    public DeviceConfigurator(BundleContext ctx) {
        this.context = ctx;
        this.hl_map = new HashMap();
        this.ll_map = new HashMap();
        try {
            this.not_available_json = new JSONArray();
            JSONObject not_available = new JSONObject();
            not_available.put("Service/function", (Object)"not available");
            this.not_available_json.put(0, (Object)not_available);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void start(ApplicationManager appManager) {
        Servlet servlet = new Servlet(this);
        this.wam = appManager.getWebAccessManager();
        this.wam.registerWebResource("/servlet", (javax.servlet.Servlet)servlet);
        this.wam.registerWebResource("/devconf", "/html_5_app");
        ServiceTrackerCustomizer<HLDriverInterface, HLDriverInterface> hl_tracker_customizer = new ServiceTrackerCustomizer<HLDriverInterface, HLDriverInterface>(){

            public HLDriverInterface addingService(ServiceReference<HLDriverInterface> sr) {
                HLDriverInterface hl_interface = (HLDriverInterface)DeviceConfigurator.this.context.getService(sr);
                DeviceConfigurator.this.hl_map.put(hl_interface.whichID(), hl_interface);
                return hl_interface;
            }

            public void modifiedService(ServiceReference<HLDriverInterface> sr, HLDriverInterface t) {
            }

            public void removedService(ServiceReference<HLDriverInterface> sr, HLDriverInterface t) {
            }
        };
        this.hl_tracker = new ServiceTracker(this.context, HLDriverInterface.class, (ServiceTrackerCustomizer)hl_tracker_customizer);
        this.hl_tracker.open();
        ServiceTrackerCustomizer<LLDriverInterface, LLDriverInterface> ll_tracker_customizer = new ServiceTrackerCustomizer<LLDriverInterface, LLDriverInterface>(){

            public LLDriverInterface addingService(ServiceReference<LLDriverInterface> sr) {
                LLDriverInterface ll_interface = (LLDriverInterface)DeviceConfigurator.this.context.getService(sr);
                DeviceConfigurator.this.ll_map.put(ll_interface.whichID(), ll_interface);
                return ll_interface;
            }

            public void modifiedService(ServiceReference<LLDriverInterface> sr, LLDriverInterface t) {
            }

            public void removedService(ServiceReference<LLDriverInterface> sr, LLDriverInterface t) {
            }
        };
        this.ll_tracker = new ServiceTracker(this.context, LLDriverInterface.class, (ServiceTrackerCustomizer)ll_tracker_customizer);
        this.ll_tracker.open();
    }

    public void stop(Application.AppStopReason reason) {
        this.wam.unregisterWebResource("/servlet");
        this.wam.unregisterWebResource("/devconf");
    }

    public JSONArray showCC(String hlDriverId, String deviceAddress) {
        if (this.hl_map.get(hlDriverId) != null) {
            return this.hl_map.get(hlDriverId).showCreatedChannels(deviceAddress);
        }
        return this.not_available_json;
    }

    public JSONObject scan(String llDriverId) {
        if (this.ll_map.get(llDriverId) != null) {
            return this.ll_map.get(llDriverId).scanForDevices();
        }
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)"unsuccessful");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public JSONObject cache(String llDriverId) {
        if (this.ll_map.get(llDriverId) != null) {
            return this.ll_map.get(llDriverId).cacheDevices();
        }
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)"unsuccessful");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public JSONObject readC(String hlDriverId, String config_data_json) {
        try {
            JSONObject config_data = new JSONObject(config_data_json);
            if (this.hl_map.get(hlDriverId) != null) {
                return this.hl_map.get(hlDriverId).readChannel(config_data.get("interfaceId").toString(), config_data.get("deviceAddress").toString(), config_data.get("channelAddress").toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.not_available_json_object;
    }

    public JSONObject showCD(String llDriverId, String interfaceId, String device, String endpoint, String clusterId) {
        if (this.ll_map.get(llDriverId) != null) {
            return this.ll_map.get(llDriverId).showClusterDetails(interfaceId, device, endpoint, clusterId);
        }
        return this.not_available_json_object;
    }

    public JSONArray showDD(String llDriverId, String interfaceId, String deviceAddress) {
        if (this.ll_map.get(llDriverId) != null) {
            return this.not_available_json;
        }
        return this.not_available_json;
    }

    public JSONArray showACC(String llDriverId) {
        if (this.ll_map.get(llDriverId) != null) {
            return this.ll_map.get(llDriverId).showAllCreatedChannels();
        }
        return this.not_available_json;
    }

    public JSONObject showH(String llDriverId) {
        return this.not_available_json_object;
    }

    public JSONObject showN(String llDriverId) {
        if (this.ll_map.get(llDriverId) != null) {
            return this.ll_map.get(llDriverId).showNetwork("-l");
        }
        return this.not_available_json_object;
    }

    public JSONArray showAllHLDrivers() {
        if (this.hl_map.keySet().size() > 0) {
            JSONArray hlDrivers = new JSONArray();
            int i = 0;
            Iterator<String> iterator = this.hl_map.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    JSONObject hlDriver = new JSONObject();
                    String interface_key = iterator.next();
                    hlDriver.put("hlDriverId", (Object)interface_key);
                    hlDrivers.put(i, (Object)hlDriver);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return hlDrivers;
        }
        return this.not_available_json;
    }

    public JSONArray showAllLLDrivers() {
        if (this.ll_map.keySet().size() > 0) {
            JSONArray llDrivers = new JSONArray();
            int i = 0;
            Iterator<String> iterator = this.ll_map.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    JSONObject llDriver = new JSONObject();
                    String interface_key = iterator.next();
                    llDriver.put("llDriverId", (Object)interface_key);
                    llDriver.put("tech", (Object)this.ll_map.get(interface_key).whichTech());
                    llDrivers.put(i, (Object)llDriver);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return llDrivers;
        }
        return this.not_available_json;
    }

    public void createC(String hlDriverId, String config_data_json) {
        System.out.println(config_data_json);
        try {
            JSONObject config_data = new JSONObject(config_data_json);
            if (this.hl_map.get(hlDriverId) != null) {
                this.hl_map.get(hlDriverId).createChannel(config_data.get("interfaceId").toString(), config_data.get("deviceAddress").toString(), config_data.get("channelAddress").toString(), Long.parseLong(config_data.get("timeout").toString()), config_data.get("resourceName").toString(), config_data.get("deviceID").toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void writeC(String hlDriverId, String config_data_json) {
        System.out.println(config_data_json);
        try {
            JSONObject config_data = new JSONObject(config_data_json);
            if (this.hl_map.get(hlDriverId) != null) {
                this.hl_map.get(hlDriverId).writeChannel(config_data.get("interfaceId").toString(), config_data.get("deviceAddress").toString(), config_data.get("channelAddress").toString(), config_data.get("writeValue").toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteC(String hlDriverId, String config_data_json) {
        try {
            JSONObject config_data = new JSONObject(config_data_json);
            if (this.hl_map.get(hlDriverId) != null) {
                this.hl_map.get(hlDriverId).deleteChannel(config_data.get("interfaceId").toString(), config_data.get("deviceAddress").toString(), config_data.get("channelAddress").toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addC(String llDriverId, String hardwareIdentifier) {
        System.out.println(hardwareIdentifier);
    }

    public void addCVP(String llDriverId, String portName) {
        System.out.println(portName);
    }
}

