/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.grafana.logging;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.ogema.apps.grafana.logging.GrafanaLogging;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceDemandListener;

class GlobalData {
    private final ResourceAccess ra;
    final Map<Class<? extends Resource>, Collection<String>> resources = new ConcurrentHashMap<Class<? extends Resource>, Collection<String>>();
    final Set<String> resourceTypes = new ConcurrentSkipListSet<String>();
    private final GlobalListener listener = new GlobalListener(this.resources, this.resourceTypes);

    GlobalData(ResourceAccess ra) {
        this.ra = ra;
        ra.addResourceDemand(SingleValueResource.class, (ResourceDemandListener)this.listener);
    }

    void close() {
        this.ra.removeResourceDemand(SingleValueResource.class, (ResourceDemandListener)this.listener);
        GrafanaLogging.logger.info("Global resource demand listener unregistered");
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private static class GlobalListener
    implements ResourceDemandListener<SingleValueResource> {
        private final Map<Class<? extends Resource>, Collection<String>> resources;
        private final Set<String> resourceTypes;

        GlobalListener(Map<Class<? extends Resource>, Collection<String>> resources, Set<String> resourceTypes) {
            GrafanaLogging.logger.info("Starting global resource demand listener");
            this.resources = resources;
            this.resourceTypes = resourceTypes;
        }

        public void resourceAvailable(SingleValueResource resource) {
            Class type = resource.getResourceType();
            if (StringResource.class.isAssignableFrom(type)) {
                return;
            }
            String typeName = type.getName();
            if (!this.resources.containsKey(type)) {
                this.resources.put(type, new ConcurrentSkipListSet());
                this.resourceTypes.add(typeName);
            }
            this.resources.get(type).add(resource.getPath());
        }

        public void resourceUnavailable(SingleValueResource resource) {
            Class type = resource.getResourceType();
            if (StringResource.class.isAssignableFrom(type)) {
                return;
            }
            String typeName = type.getName();
            if (!this.resources.containsKey(type)) {
                return;
            }
            this.resources.get(type).remove(resource.getPath());
            if (this.resources.get(type).isEmpty()) {
                this.resources.remove(type);
                this.resourceTypes.remove(typeName);
            }
        }
    }
}

