/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.grafana.logging;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.ogema.apps.grafana.logging.GlobalData;
import org.ogema.apps.grafana.logging.SessionData;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.tools.grafana.base.InfluxFake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(specVersion="1.2")
@Service(value={Application.class})
public class GrafanaLogging
implements Application {
    private static final String SESSION_ATTRIBUTE_INIT = "grafana_logging_data";
    static final Logger logger = LoggerFactory.getLogger(GrafanaLogging.class);
    private ApplicationManager am;
    private ResourceAccess ra;
    private InfluxFake infl;
    private DataSupplierImpl supplier;
    private String webResourceBrowserPath;
    private String servletPath;

    public void start(ApplicationManager am) {
        this.am = am;
        this.ra = am.getResourceAccess();
        logger.debug("Grafana logging app started", (Object)this.getClass().getName());
        String webResourcePackagePath = "org/ogema/apps/grafana/logging/grafana-1.9.1";
        String appNameLowerCase = "GrafanaLogging".toLowerCase();
        this.webResourceBrowserPath = "/ogema/" + appNameLowerCase;
        am.getWebAccessManager().registerWebResource(this.webResourceBrowserPath, webResourcePackagePath);
        this.supplier = new DataSupplierImpl(this.ra);
        this.infl = new InfluxFake(am, Collections.emptyMap(), 5000){
            private static final long serialVersionUID = 1L;

            protected void onGet(HttpServletRequest req) {
                SessionData o;
                HttpSession session = req.getSession();
                try {
                    o = (SessionData)session.getAttribute(GrafanaLogging.SESSION_ATTRIBUTE_INIT);
                }
                catch (ClassCastException e) {
                    session.removeAttribute(GrafanaLogging.SESSION_ATTRIBUTE_INIT);
                    o = null;
                }
                if (o == null || this.ra == null) {
                    o = new SessionData(GrafanaLogging.this.supplier, this.ra);
                    session.setAttribute(GrafanaLogging.SESSION_ATTRIBUTE_INIT, (Object)o);
                }
            }

            public Map<String, Map> getPanels(HttpServletRequest req) {
                HttpSession session = req.getSession();
                SessionData o = (SessionData)session.getAttribute(GrafanaLogging.SESSION_ATTRIBUTE_INIT);
                if (o == null) {
                    return Collections.emptyMap();
                }
                return o.getPanels();
            }

            protected List<? extends Resource> getResources(Class<? extends Resource> clazz, HttpServletRequest req) {
                HttpSession session = req.getSession();
                SessionData o = (SessionData)session.getAttribute(GrafanaLogging.SESSION_ATTRIBUTE_INIT);
                if (o == null) {
                    return Collections.emptyList();
                }
                return o.getResources(clazz);
            }

            protected Class getClass(String longResTypeName, HttpServletRequest req) {
                HttpSession session = req.getSession();
                SessionData o = (SessionData)session.getAttribute(GrafanaLogging.SESSION_ATTRIBUTE_INIT);
                if (o == null) {
                    return null;
                }
                return o.getClass(longResTypeName);
            }
        };
        this.infl.setStrictMode(true);
        this.servletPath = "/apps/ogema/" + appNameLowerCase + "/fake_influxdb/series";
        am.getWebAccessManager().registerWebResource(this.servletPath, (Servlet)this.infl);
    }

    public void stop(Application.AppStopReason reason) {
        if (this.am != null) {
            try {
                this.am.getWebAccessManager().unregisterWebResource(this.webResourceBrowserPath);
                this.am.getWebAccessManager().unregisterWebResource(this.servletPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.am = null;
        this.ra = null;
        this.infl = null;
        DataSupplierImpl supplier = this.supplier;
        this.supplier = null;
        if (supplier != null) {
            supplier.close();
        }
    }

    private static class DataSupplierImpl
    implements SessionData.DataSupplier {
        private final Object dataLock = new Object();
        private volatile WeakReference<GlobalData> globalData = new WeakReference<Object>(null);
        private final ResourceAccess ra;

        DataSupplierImpl(ResourceAccess ra) {
            this.ra = ra;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GlobalData getGlobalData() {
            WeakReference<GlobalData> reference = this.globalData;
            if (reference == null) {
                return null;
            }
            GlobalData data = (GlobalData)reference.get();
            if (data != null) {
                return data;
            }
            Object object = this.dataLock;
            synchronized (object) {
                data = (GlobalData)this.globalData.get();
                if (data != null) {
                    return data;
                }
                data = new GlobalData(this.ra);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.globalData = new WeakReference<GlobalData>(data);
                return data;
            }
        }

        void close() {
            GlobalData gd = (GlobalData)this.globalData.get();
            if (gd != null) {
                gd.close();
            }
            this.globalData = null;
        }
    }
}

