/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.grafana.logging;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ogema.apps.grafana.logging.GlobalData;
import org.ogema.core.model.Resource;
import org.ogema.core.resourcemanager.ResourceAccess;

class SessionData {
    private final ResourceAccess ra;
    private final DataSupplier globalDataSupplier;
    private volatile SoftReference<GlobalData> softRef;

    SessionData(DataSupplier globalDataSupplier, ResourceAccess ra) {
        this.globalDataSupplier = globalDataSupplier;
        this.ra = ra;
        this.softRef = new SoftReference<GlobalData>(globalDataSupplier.getGlobalData());
    }

    Class<? extends Resource> getClass(String name) {
        GlobalData global = this.getGlobalData();
        for (Class<? extends Resource> type : global.resources.keySet()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    Map<String, Map> getPanels() {
        GlobalData global = this.getGlobalData();
        LinkedHashMap<String, Map> panels = new LinkedHashMap<String, Map>(global.resources.size());
        for (Class<? extends Resource> key : global.resources.keySet()) {
            panels.put(key.getName(), Collections.singletonMap(key.getSimpleName(), key));
        }
        return panels;
    }

    List<? extends Resource> getResources(Class<? extends Resource> clazz) {
        GlobalData global = this.getGlobalData();
        Collection<String> list = global.resources.get(clazz);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(list.size());
        for (String path : list) {
            try {
                Resource r = this.ra.getResource(path);
                if (r == null) continue;
                resources.add(r);
            }
            catch (Exception exception) {}
        }
        return resources;
    }

    private GlobalData getGlobalData() {
        GlobalData initial = this.softRef.get();
        if (initial != null) {
            return initial;
        }
        initial = this.globalDataSupplier.getGlobalData();
        this.softRef = new SoftReference<GlobalData>(initial);
        return initial;
    }

    static interface DataSupplier {
        public GlobalData getGlobalData();
    }
}

