/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.graphgenerator;

import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.ogema.apps.graphgenerator.GraphGenServlet;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;

@Component(specVersion="1.2", immediate=true)
@Service(value={Application.class})
public class GeneratorApplication
implements Application {
    private static final String MAINPAGE_ALIAS = "/ogema/graphgenerator";
    private static final String SERVLET_ALIAS = "/apps/ogema/graphgenerator";
    private OgemaLogger logger;
    private ApplicationManager appMan;
    private GraphGenServlet servlet;

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        this.logger = appManager.getLogger();
        this.servlet = new GraphGenServlet(appManager);
        this.logger.debug("{} started", (Object)this.getClass().getName());
        appManager.getWebAccessManager().registerWebResource(MAINPAGE_ALIAS, "org/ogema/app/graphgenerator/gui");
        appManager.getWebAccessManager().registerWebResource(SERVLET_ALIAS, (Servlet)this.servlet);
    }

    public void stop(Application.AppStopReason reason) {
        if (this.appMan != null) {
            this.appMan.getWebAccessManager().unregisterWebResource(MAINPAGE_ALIAS);
            this.appMan.getWebAccessManager().unregisterWebResource(SERVLET_ALIAS);
        }
        if (this.logger != null) {
            this.logger.debug("{} stopped", (Object)this.getClass().getName());
        }
        this.appMan = null;
        this.logger = null;
        this.servlet = null;
    }
}

