/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.graphgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.ogema.apps.graphgenerator.generators.GraphGenerator;
import org.ogema.apps.graphgenerator.generators.GraphwizGenerator;
import org.ogema.apps.graphgenerator.generators.VisJsGenerator;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.Resource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.tools.SerializationManager;
import org.ogema.model.sensors.TemperatureSensor;

public class GraphGenServlet
extends HttpServlet {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = 1L;
    private final ApplicationManager am;
    private final ResourceAccess resAcc;
    private final SerializationManager serMan;
    private final OgemaLogger logger;

    public GraphGenServlet(ApplicationManager am) {
        this.am = am;
        this.resAcc = am.getResourceAccess();
        this.serMan = am.getSerializationManager();
        this.logger = am.getLogger();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List topLR = this.resAcc.getToplevelResources(Resource.class);
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(Resource.class.getName());
        for (Resource res : topLR) {
            types.add(res.getResourceType().getName());
        }
        JSONArray returnTypes = new JSONArray(types);
        resp.getWriter().write(returnTypes.toString());
        resp.setStatus(200);
        resp.setContentType("application/json");
        resp.flushBuffer();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            GraphGenerator generator;
            String selectedGenerator = req.getParameter("generator");
            String resourceType = req.getParameter("resourceType");
            String plotType = req.getParameter("plottype");
            String pce = req.getParameter("enable_phys_conf");
            Boolean physConfEnabled = Boolean.valueOf(pce != null ? pce : "false");
            if (selectedGenerator == null || plotType == null) {
                resp.getWriter().write("Error: no generator or no plot type selected!");
                resp.setStatus(400);
                return;
            }
            switch (selectedGenerator) {
                case "visjs": {
                    generator = new VisJsGenerator(this.logger, this.serMan);
                    ((VisJsGenerator)generator).setPhysConfigurationEnabled(physConfEnabled);
                    break;
                }
                case "graphviz": {
                    generator = new GraphwizGenerator(this.am);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid generator selected");
                }
            }
            Object result = null;
            Class<? extends Resource> type = this.getClassForName(resourceType);
            switch (plotType) {
                case "all": {
                    result = generator.generateResourcesGraph(type, this.resAcc);
                    break;
                }
                case "connections": {
                    result = generator.generateConnectionsGraph(this.resAcc);
                    break;
                }
                default: {
                    resp.getWriter().write("plot type not known: " + plotType);
                    resp.setStatus(400);
                    return;
                }
            }
            if (result != null) {
                if (result instanceof File) {
                    int length;
                    resp.setContentType("application/force-download");
                    resp.setContentLength((int)((File)result).length());
                    resp.setHeader("Content-Transfer-Encoding", "binary");
                    resp.addHeader("Content-Disposition", "attachment; filename=\"resources.graph\"");
                    ServletOutputStream out = resp.getOutputStream();
                    FileInputStream in = new FileInputStream((File)result);
                    byte[] buffer = new byte[4096];
                    while ((length = in.read(buffer)) > 0) {
                        out.write(buffer, 0, length);
                    }
                    in.close();
                    out.flush();
                } else {
                    resp.getWriter().write(result.toString());
                }
                resp.setStatus(200);
            } else {
                resp.setStatus(500);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Class<? extends Resource> getClassForName(String resourceType) {
        Class type = Resource.class;
        try {
            type = Class.forName(resourceType);
        }
        catch (Exception e) {
            try {
                try {
                    type = Class.forName(resourceType, false, TemperatureSensor.class.getClassLoader());
                }
                catch (Exception eee) {
                    List ress = this.resAcc.getToplevelResources(Resource.class);
                    boolean found = false;
                    for (Resource top : ress) {
                        Class type2 = top.getResourceType();
                        if (!type2.getName().equals(resourceType)) continue;
                        type = type2;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.logger.error("Could not retrieve class for " + resourceType, (Throwable)e);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type;
    }
}

