/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.graphgenerator.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ogema.apps.graphgenerator.generators.GraphGenerator;
import org.ogema.apps.graphgenerator.generators.VisJsData;
import org.ogema.apps.graphgenerator.generators.visjs.Color;
import org.ogema.apps.graphgenerator.generators.visjs.Edge;
import org.ogema.apps.graphgenerator.generators.visjs.Node;
import org.ogema.apps.graphgenerator.generators.visjs.Options;
import org.ogema.apps.graphgenerator.generators.visjs.TopLevelDummyNode;
import org.ogema.apps.graphgenerator.styles.EdgeStyle;
import org.ogema.apps.graphgenerator.styles.NodeStyle;
import org.ogema.apps.graphgenerator.styles.gviz.EdgeStyleBase;
import org.ogema.apps.graphgenerator.styles.gviz.NodeStyleBlue;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ValueResource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.tools.SerializationManager;

public class VisJsGenerator
extends GraphGenerator {
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private SerializationManager serMan;
    private Options options = new Options();

    public VisJsGenerator(OgemaLogger logger, SerializationManager serMan) {
        super(logger);
        this.serMan = serMan;
    }

    @Override
    public void init() {
    }

    @Override
    public void addNode(Resource node) {
        NodeStyleBlue style = new NodeStyleBlue();
        if (node instanceof ValueResource) {
            style.setShape("box");
        }
        this.addNode(node, style);
    }

    @Override
    public void addNode(Resource node, NodeStyle style) {
        String resLocation = node.getLocation("__");
        String resType = node.getResourceType().getSimpleName();
        ArrayList<String> labels = new ArrayList<String>();
        if (style.addType()) {
            labels.add(node.getResourceType().getSimpleName());
        }
        if (style.addName()) {
            labels.add(node.getName());
        }
        if (style.addLocation()) {
            labels.add(node.getLocation());
        }
        if (style.addSimpleValues() && (node instanceof BooleanResource || node instanceof FloatResource || node instanceof IntegerResource || node instanceof IntegerResource || node instanceof StringResource || node instanceof TimeResource)) {
            String value = this.getSimpleValue((ValueResource)node);
            labels.add("value = " + value);
        }
        Node newNode = new Node(new Color(), resLocation, "", style.getShape());
        for (String sublabel : labels) {
            newNode.setLabel(newNode.getLabel() + "\n" + sublabel);
        }
        this.nodes.add(newNode);
    }

    @Override
    public void addEdge(Resource start, Resource end, EdgeStyle style) {
        if (style == null) {
            style = new EdgeStyleBase();
        }
        String loc1 = start.getLocation("__");
        String loc2 = end.getLocation("__");
        Edge edge = new Edge(loc1, loc2, Edge.VisJsEdgeStyle.ARROW);
        if (end.isReference(false)) {
            edge.setStyle(Edge.VisJsEdgeStyle.DASH_LINE.getStyleIdentifier());
        }
        this.edges.add(edge);
    }

    @Override
    public void addGroup(Collection<Resource> resources, String name) {
    }

    @Override
    public synchronized Object generateAllResourcesGraph(ResourceAccess resAcc) {
        this.addTopLevelDummy(resAcc);
        return super.generateAllResourcesGraph(resAcc);
    }

    @Override
    public synchronized Object generateResourcesGraph(Class<? extends Resource> topLevelType, ResourceAccess resAcc) {
        this.addTopLevelDummy(topLevelType, resAcc);
        return super.generateResourcesGraph(topLevelType, resAcc);
    }

    @Override
    public synchronized Object generateConnectionsGraph(ResourceAccess resAcc) {
        return super.generateConnectionsGraph(resAcc);
    }

    @Override
    public Object finish() {
        return this.getGraph();
    }

    @Override
    public String getGraph() {
        return this.serMan.toJson((Object)new VisJsData(this.nodes, this.edges, this.options));
    }

    private void addTopLevelDummy(ResourceAccess resAcc) {
        this.addTopLevelDummy(Resource.class, resAcc);
    }

    private void addTopLevelDummy(Class<? extends Resource> resourceType, ResourceAccess resAcc) {
        TopLevelDummyNode topLevelDummy = new TopLevelDummyNode();
        this.addNode(topLevelDummy);
        List toplevelResources = resAcc.getToplevelResources(resourceType);
        for (Resource topLevelResource : toplevelResources) {
            this.addEdge(topLevelDummy, topLevelResource);
        }
    }

    public void setPhysConfigurationEnabled(boolean enabled) {
        this.options.setConfigurePhysics(enabled);
    }
}

