/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.graphgenerator.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ogema.apps.graphgenerator.styles.EdgeStyle;
import org.ogema.apps.graphgenerator.styles.NodeStyle;
import org.ogema.apps.graphgenerator.styles.gviz.EdgeStyleBase;
import org.ogema.apps.graphgenerator.styles.gviz.NodeStyleBlue;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ValueResource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.model.units.PhysicalUnitResource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.model.connections.ThermalConnection;
import org.ogema.model.prototypes.Connection;
import org.ogema.model.prototypes.PhysicalElement;

public abstract class GraphGenerator {
    public static final String PATH_SEP = "__";
    protected OgemaLogger logger;

    public GraphGenerator(OgemaLogger logger) {
        this.logger = logger;
    }

    public abstract void init();

    public abstract void addNode(Resource var1);

    public abstract void addNode(Resource var1, NodeStyle var2);

    public void addEdge(Resource start, Resource end) {
        this.addEdge(start, end, null);
    }

    public abstract void addEdge(Resource var1, Resource var2, EdgeStyle var3);

    public abstract void addGroup(Collection<Resource> var1, String var2);

    public abstract Object finish();

    public abstract String getGraph();

    public Object generateAllResourcesGraph(ResourceAccess resAcc) {
        return this.generateResourcesGraph(Resource.class, resAcc);
    }

    public synchronized Object generateResourcesGraph(Class<? extends Resource> topLevelType, ResourceAccess resAcc) {
        this.init();
        this.logger.debug("Writing the groups and the resources for type " + topLevelType.getName());
        List topLevelResources = resAcc.getToplevelResources(topLevelType);
        for (Resource root : topLevelResources) {
            List groupElements = root.getDirectSubResources(true);
            groupElements.add(root);
            if (groupElements.size() <= 2) continue;
            this.addGroup(groupElements, root.getLocation("_"));
        }
        List resources = topLevelResources;
        ArrayList<String> nodeLocations = new ArrayList<String>();
        for (Resource resource : resources) {
            this.addNode(resource);
            nodeLocations.add(resource.getLocation());
        }
        this.logger.debug("Writing edges.");
        for (Resource resource : resources) {
            this.addSubresources(resource, nodeLocations);
        }
        return this.finish();
    }

    private void addSubresources(Resource parent, List<String> nodeLocations) {
        List subresources = parent.getSubResources(false);
        for (Resource subres : subresources) {
            this.addEdge(parent, subres);
            String loc = subres.getLocation();
            if (nodeLocations.contains(loc)) continue;
            this.addNode(subres);
            nodeLocations.add(loc);
            this.addSubresources(subres, nodeLocations);
        }
    }

    public synchronized <T extends Resource> Object generateGraph(ResourceAccess resAcc, Class<T> clazz) {
        this.init();
        NodeStyleBlue defaultNodeStyle = new NodeStyleBlue();
        EdgeStyleBase defaultEdgeStyle = new EdgeStyleBase();
        List resources = resAcc.getResources(clazz);
        for (Resource res : resources) {
            this.addNode(res);
            Resource directParent = res.getParent();
            List parents = res.getReferencingResources(Resource.class);
            if (directParent != null) {
                parents.add(directParent);
            }
            for (Resource parent : parents) {
                this.addNode(parent, defaultNodeStyle);
                this.addEdge(parent, res, defaultEdgeStyle);
            }
        }
        return this.finish();
    }

    public synchronized Object generateConnectionsGraph(ResourceAccess resAcc) {
        this.init();
        NodeStyleBlue defaultNodeStyle = new NodeStyleBlue();
        NodeStyleBlue thermalNodeStyle = new NodeStyleBlue();
        thermalNodeStyle.setActiveColor("red");
        EdgeStyleBase defaultEdgeStyle = new EdgeStyleBase();
        List connections = resAcc.getResources(Connection.class);
        for (Connection connection : connections) {
            PhysicalElement out;
            NodeStyleBlue nodeStyle = connection instanceof ThermalConnection ? thermalNodeStyle : defaultNodeStyle;
            this.addNode((Resource)connection, nodeStyle);
            PhysicalElement in = (PhysicalElement)resAcc.getResource(connection.input().getLocation());
            if (in.exists()) {
                this.addNode((Resource)in, defaultNodeStyle);
                this.addEdge((Resource)connection, (Resource)in, defaultEdgeStyle);
            }
            if ((out = (PhysicalElement)resAcc.getResource(connection.output().getLocation())).exists()) {
                this.addNode((Resource)out, defaultNodeStyle);
                this.addEdge((Resource)connection, (Resource)out, defaultEdgeStyle);
            }
            Resource directParent = connection.getParent();
            List parents = connection.getReferencingResources(Resource.class);
            if (directParent != null) {
                parents.add(directParent);
            }
            for (Resource parent : parents) {
                this.addNode(parent, defaultNodeStyle);
                this.addEdge(parent, (Resource)connection, defaultEdgeStyle);
            }
        }
        return this.finish();
    }

    protected String getSimpleValue(ValueResource resource) {
        String resType = resource.getResourceType().getSimpleName();
        if (resource instanceof PhysicalUnitResource) {
            PhysicalUnitResource res = (PhysicalUnitResource)resource;
            return res.getValue() + " " + res.getUnit();
        }
        if (resource instanceof FloatResource) {
            FloatResource res = (FloatResource)resource;
            return new Float(res.getValue()).toString();
        }
        if (resource instanceof BooleanResource) {
            BooleanResource res = (BooleanResource)resource;
            return res.getValue() ? "true" : "false";
        }
        if (resource instanceof IntegerResource) {
            IntegerResource res = (IntegerResource)resource;
            return new Integer(res.getValue()).toString();
        }
        if (resource instanceof StringResource) {
            StringResource res = (StringResource)resource;
            return res.getValue();
        }
        if (resource instanceof TimeResource) {
            TimeResource res = (TimeResource)resource;
            return new Long(res.getValue()).toString();
        }
        throw new RuntimeException("Unknown or unimplemented simple resource type " + resType.toString());
    }
}

