/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.graphgenerator.generators;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.ogema.apps.graphgenerator.generators.GraphGenerator;
import org.ogema.apps.graphgenerator.styles.EdgeStyle;
import org.ogema.apps.graphgenerator.styles.NodeStyle;
import org.ogema.apps.graphgenerator.styles.gviz.EdgeStyleBase;
import org.ogema.apps.graphgenerator.styles.gviz.NodeStyleBlue;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ValueResource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;

public class GraphwizGenerator
extends GraphGenerator {
    private final StringBuilder m_graph = new StringBuilder();
    private final ApplicationManager am;
    private final NodeStyle defaultNodeStyle = new NodeStyleBlue();
    private final NodeStyle thermalNodeStyle = new NodeStyleBlue();

    public GraphwizGenerator(ApplicationManager am) {
        super(am.getLogger());
        this.am = am;
        this.thermalNodeStyle.setActiveColor("red");
    }

    private final String getHeader() {
        return "digraph G {\nnode [style=filled, fontcolor=\"white\"]\nedge [penwidth=2]\n\n";
    }

    public String toString() {
        return this.m_graph.toString() + "\n}\n";
    }

    @Override
    public void init() {
        this.m_graph.append(this.getHeader());
    }

    @Override
    public void addNode(Resource node) {
        NodeStyleBlue style = new NodeStyleBlue();
        if (node instanceof ValueResource) {
            style.setShape("rectangle");
        }
        this.addNode(node, style);
    }

    @Override
    public void addNode(Resource node, NodeStyle style) {
        String resLocation = node.getLocation("__");
        String resType = node.getResourceType().getSimpleName();
        this.m_graph.append(resLocation).append(" [ ");
        ArrayList<String> labels = new ArrayList<String>();
        if (style.addType()) {
            labels.add(resType);
        }
        if (style.addName()) {
            labels.add(node.getName());
        }
        if (style.addLocation()) {
            labels.add(node.getLocation());
        }
        if (style.addSimpleValues() && (node instanceof BooleanResource || node instanceof FloatResource || node instanceof IntegerResource || node instanceof IntegerResource || node instanceof StringResource || node instanceof TimeResource)) {
            String value = this.getSimpleValue((ValueResource)node);
            labels.add("value = " + value);
        }
        StringBuilder label = new StringBuilder();
        label.append("label=\"");
        for (String sublabel : labels) {
            label.append(sublabel).append("\\n");
        }
        label.append("\"");
        this.m_graph.append((CharSequence)label);
        this.m_graph.append(" shape=").append(style.getShape());
        if (node.isActive()) {
            this.m_graph.append(" color=").append(style.getActiveColor());
        } else {
            this.m_graph.append(" color=").append(style.getInactiveColor());
        }
        this.m_graph.append(" ]\n");
    }

    @Override
    public void addEdge(Resource start, Resource end, EdgeStyle style) {
        if (style == null) {
            style = new EdgeStyleBase();
        }
        String loc1 = start.getLocation("__");
        String loc2 = end.getLocation("__");
        this.m_graph.append(loc1).append(" -> ").append(loc2);
        this.m_graph.append(" [ color=").append(style.getColor());
        if (end.isReference(false)) {
            this.m_graph.append(" style=").append(style.getReferenceStyle()).append(" ]");
        } else {
            this.m_graph.append(" style=").append(style.getDefaultStyle()).append(" ]");
        }
        this.m_graph.append("\n");
    }

    @Override
    public Object finish() {
        this.m_graph.append("\n}\n");
        try {
            File file = this.am.getDataFile("resources.graph");
            PrintWriter writer = new PrintWriter(file, "UTF-8");
            writer.println(this.getGraph());
            writer.close();
            return file;
        }
        catch (FileNotFoundException | UnsupportedEncodingException ex) {
            this.logger.error("Could not write to file.");
            return null;
        }
    }

    @Override
    public String getGraph() {
        return this.m_graph.toString();
    }

    @Override
    public void addGroup(Collection<Resource> resources, String name) {
        this.m_graph.append("subgraph cluster_").append(name).append(" { style=filled color=gray90 ");
        this.m_graph.append("label=").append(name).append(" \n");
        for (Resource resource : resources) {
            this.addNode(resource);
        }
        this.m_graph.append("\n}\n");
    }
}

