/*
 * Decompiled with CFR 0.152.
 */
package ogema.logging.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.servlet.Servlet;
import ogema.logging.app.LoggingAppServlet;
import ogema.logging.app.ShellCommands;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.recordeddata.RecordedData;
import org.ogema.core.recordeddata.RecordedDataConfiguration;
import org.ogema.model.actors.Actor;
import org.ogema.model.sensors.Sensor;
import org.ogema.model.targetranges.TargetRange;
import org.osgi.framework.ServiceRegistration;

@Component(specVersion="1.2")
@Service(value={Application.class})
public class LoggingApp
implements Application {
    ApplicationManager am;
    private String webResourceBrowserPath;
    private String servletPath;
    private ServiceRegistration<?> shellCommands;

    public void start(ApplicationManager appManager) {
        this.am = appManager;
        this.am.getLogger().debug("{} started", (Object)this.getClass().getName());
        String webResourcePackage = "ogema.logging.app";
        webResourcePackage = webResourcePackage.replace(".", "/");
        String appNameLowerCase = "LoggingApp";
        appNameLowerCase = appNameLowerCase.toLowerCase();
        this.webResourceBrowserPath = "/ogema/" + appNameLowerCase;
        String webResourcePackagePath = webResourcePackage + "/gui";
        this.servletPath = "/apps/ogema/" + appNameLowerCase;
        appManager.getWebAccessManager().registerWebResource(this.webResourceBrowserPath, webResourcePackagePath);
        appManager.getWebAccessManager().registerWebResource(this.servletPath, (Servlet)new LoggingAppServlet(this));
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("osgi.command.scope", "ogm");
        props.put("osgi.command.function", new String[]{"getLoggedResources", "getLoggingConfig", "isLoggingActive", "logAllActors", "logAllSensors", "startLogging", "stopLogging"});
        try {
            this.shellCommands = this.am.getAppID().getBundle().getBundleContext().registerService(ShellCommands.class, (Object)new ShellCommands(this), props);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void stop(Application.AppStopReason reason) {
        ServiceRegistration<?> sreg = this.shellCommands;
        this.shellCommands = null;
        if (sreg != null) {
            try {
                sreg.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.am != null) {
            this.am.getWebAccessManager().unregisterWebResource(this.webResourceBrowserPath);
            this.am.getWebAccessManager().unregisterWebResource(this.servletPath);
        }
        this.am = null;
    }

    int logAllSensors() {
        int cnt = 0;
        for (Sensor sensor : this.am.getResourceAccess().getResources(Sensor.class)) {
            if (!LoggingApp.logIfNotActive((Resource)sensor.reading())) continue;
            ++cnt;
        }
        for (Actor actor : this.am.getResourceAccess().getResources(Actor.class)) {
            if (!LoggingApp.logIfNotActive((Resource)actor.stateFeedback())) continue;
            ++cnt;
        }
        return cnt;
    }

    int logAllActors() {
        int cnt = 0;
        for (Actor actor : this.am.getResourceAccess().getResources(Actor.class)) {
            if (!LoggingApp.logIfNotActive((Resource)actor.stateControl())) continue;
            ++cnt;
        }
        for (TargetRange range : this.am.getResourceAccess().getResources(TargetRange.class)) {
            if (!LoggingApp.logIfNotActive((Resource)range.setpoint())) continue;
            ++cnt;
        }
        return cnt;
    }

    boolean activateLogging(String path) {
        Resource r = this.am.getResourceAccess().getResource(path);
        if (r == null) {
            return false;
        }
        return LoggingApp.logIfNotActive(r);
    }

    boolean stopLogging(String path) {
        Resource r = this.am.getResourceAccess().getResource(path);
        if (r == null) {
            return false;
        }
        RecordedData rd = LoggingApp.getRecordedData(r);
        if (rd == null || rd.getConfiguration() == null) {
            return false;
        }
        rd.setConfiguration(null);
        return true;
    }

    Collection<Resource> getLoggedResources() {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (SingleValueResource res : this.am.getResourceAccess().getResources(SingleValueResource.class)) {
            if (!LoggingApp.isLoggingActive((Resource)res)) continue;
            list.add((Resource)res);
        }
        return list;
    }

    boolean isLoggingActive(String path) {
        Resource r = this.am.getResourceAccess().getResource(path);
        if (r == null) {
            return false;
        }
        return LoggingApp.isLoggingActive(r);
    }

    RecordedDataConfiguration getLoggingConfiguration(String path) {
        Resource r = this.am.getResourceAccess().getResource(path);
        if (r == null) {
            return null;
        }
        RecordedData rd = LoggingApp.getRecordedData(r);
        if (rd == null) {
            return null;
        }
        return rd.getConfiguration();
    }

    private static boolean isLoggingActive(Resource r) {
        RecordedData rd = LoggingApp.getRecordedData(r);
        if (rd == null) {
            return false;
        }
        return rd.getConfiguration() != null;
    }

    private static boolean logIfNotActive(Resource r) {
        if (!r.isActive()) {
            return false;
        }
        RecordedData rd = LoggingApp.getRecordedData(r);
        if (rd == null || rd.getConfiguration() != null) {
            return false;
        }
        RecordedDataConfiguration cfg = new RecordedDataConfiguration();
        cfg.setStorageType(RecordedDataConfiguration.StorageType.ON_VALUE_UPDATE);
        rd.setConfiguration(cfg);
        return true;
    }

    static RecordedData getRecordedData(Resource res) {
        RecordedData rd = null;
        if (res instanceof FloatResource) {
            FloatResource fl = (FloatResource)res;
            rd = fl.getHistoricalData();
        } else if (res instanceof IntegerResource) {
            IntegerResource fl = (IntegerResource)res;
            rd = fl.getHistoricalData();
        } else if (res instanceof BooleanResource) {
            BooleanResource fl = (BooleanResource)res;
            rd = fl.getHistoricalData();
        } else if (res instanceof TimeResource) {
            TimeResource tr = (TimeResource)res;
            rd = tr.getHistoricalData();
        }
        return rd;
    }
}

