/*
 * Decompiled with CFR 0.152.
 */
package ogema.logging.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ogema.logging.app.LoggingApp;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.recordeddata.RecordedData;
import org.ogema.core.recordeddata.RecordedDataConfiguration;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingAppServlet
extends HttpServlet {
    private static final long serialVersionUID = -623919478854332527L;
    private static final Logger logger = LoggerFactory.getLogger(LoggingApp.class);
    private final ResourceAccess ra;
    private final LoggingApp app;

    LoggingAppServlet(LoggingApp app) {
        this.app = app;
        this.ra = app.am.getResourceAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int status;
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = req.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        String request = sb.toString();
        String response = "";
        try {
            JSONObject json = new JSONObject(request);
            logger.debug("  JSON object: {}", (Object)json);
            if (json.has("target")) {
                this.handleActivateRequests(json, resp);
                return;
            }
            String location = json.getString("resource");
            boolean record = json.getBoolean("record");
            String logType = json.getString("logType");
            long intv = 30000L;
            try {
                intv = json.getLong("interval") * 1000L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Resource resource = this.ra.getResource(location);
            RecordedData rd = LoggingApp.getRecordedData(resource);
            if (rd == null) {
                response = "An error occurred. Could not change log settings.";
                resp.getWriter().write(response);
                resp.setStatus(200);
                return;
            }
            RecordedDataConfiguration configuration = new RecordedDataConfiguration();
            if (record) {
                configuration.setStorageType(RecordedDataConfiguration.StorageType.valueOf((String)logType));
                configuration.setFixedInterval(intv);
                rd.setConfiguration(configuration);
            } else {
                rd.setConfiguration(null);
            }
            response = response + "New configuration for " + location + ":";
            try {
                response = response + " interval " + String.valueOf(rd.getConfiguration().getFixedInterval()) + "ms, storage type: " + rd.getConfiguration().getStorageType().toString();
            }
            catch (Exception ee) {
                response = response + " not logging.";
            }
            status = 200;
        }
        catch (Exception e) {
            response = response + "An error occurred. Could not change log settings: " + e.toString();
            status = 500;
        }
        resp.getWriter().write(response);
        resp.setStatus(status);
    }

    private void handleActivateRequests(JSONObject json, HttpServletResponse resp) throws IOException {
        int activated;
        String target = json.getString("target");
        switch (target.toLowerCase()) {
            case "logsensors": {
                activated = this.app.logAllSensors();
                break;
            }
            case "logactors": {
                activated = this.app.logAllActors();
                break;
            }
            default: {
                resp.sendError(400, "Unknown request target: " + target);
                return;
            }
        }
        resp.setContentType("application/json");
        resp.getWriter().write("{\"activated\":" + activated + "}");
        resp.setStatus(200);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        JSONArray array = new JSONArray();
        List resources = this.ra.getResources(SingleValueResource.class);
        Collections.sort(resources, new ResourcesComparator());
        for (Resource res : resources) {
            if (res instanceof StringResource) continue;
            try {
                array.put((Object)LoggingAppServlet.getResourceObject(res));
            }
            catch (Exception e) {
                logger.warn("  Exception caught during request: " + e.toString());
            }
        }
        logger.debug("  Answer: {}", (Object)array);
        resp.getWriter().write(array.toString());
        resp.setStatus(200);
    }

    private static JSONObject getResourceObject(Resource resource) {
        JSONObject object = new JSONObject();
        object.put("Location", (Object)resource.getLocation());
        object.put("Type", (Object)resource.getResourceType().getSimpleName());
        object.put("active", (Object)String.valueOf(resource.isActive()));
        if (resource instanceof SingleValueResource) {
            String[] valueLog = LoggingAppServlet.getSimpleResString2(resource);
            object.put("value", (Object)valueLog[0]);
            boolean logg = !valueLog[1].equals("");
            object.put("logging", (Object)String.valueOf(logg));
            if (logg) {
                object.put("log interval/s", (Object)valueLog[2]);
                object.put("logging type", (Object)valueLog[1]);
            }
        }
        return object;
    }

    private static String[] getSimpleResString2(Resource sres) {
        boolean logging;
        String loggingDur;
        String loggingType;
        String value;
        block23: {
            value = "";
            loggingType = "";
            loggingDur = "";
            logging = false;
            RecordedDataConfiguration config = null;
            try {
                if (sres instanceof StringResource) {
                    StringResource strRes = (StringResource)sres;
                    value = strRes.getValue();
                } else if (sres instanceof FloatResource) {
                    FloatResource floatRes = (FloatResource)sres;
                    value = String.valueOf(floatRes.getValue());
                    try {
                        config = floatRes.getHistoricalData().getConfiguration();
                    }
                    catch (Exception exception) {}
                } else if (sres instanceof IntegerResource) {
                    IntegerResource intRes = (IntegerResource)sres;
                    value = String.valueOf(intRes.getValue());
                    try {
                        config = intRes.getHistoricalData().getConfiguration();
                    }
                    catch (Exception exception) {}
                } else if (sres instanceof BooleanResource) {
                    BooleanResource boolRes = (BooleanResource)sres;
                    value = String.valueOf(boolRes.getValue());
                    try {
                        config = boolRes.getHistoricalData().getConfiguration();
                    }
                    catch (Exception exception) {}
                } else if (sres instanceof TimeResource) {
                    TimeResource timeRes = (TimeResource)sres;
                    value = String.valueOf(timeRes.getValue());
                    try {
                        config = timeRes.getHistoricalData().getConfiguration();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    loggingType = config.getStorageType().name();
                    loggingDur = String.valueOf(config.getFixedInterval() / 1000L);
                    if (config.getStorageType().equals((Object)RecordedDataConfiguration.StorageType.FIXED_INTERVAL)) {
                        if (config.getFixedInterval() > 0L) {
                            logging = true;
                        }
                        break block23;
                    }
                    logging = true;
                }
                catch (Exception timeRes) {}
            }
            catch (Exception e) {
                logger.warn("Exception caught: " + e.toString());
            }
        }
        String[] result = new String[]{value, loggingType, loggingDur, String.valueOf(logging)};
        return result;
    }

    private static class ResourcesComparator
    implements Comparator<Resource> {
        private ResourcesComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            return o1.getLocation().toLowerCase().compareTo(o2.getLocation().toLowerCase());
        }
    }
}

