/*
 * Decompiled with CFR 0.152.
 */
package ogema.logging.app;

import java.util.Collection;
import ogema.logging.app.LoggingApp;
import org.apache.felix.service.command.Descriptor;
import org.ogema.core.model.Resource;
import org.ogema.core.recordeddata.RecordedDataConfiguration;

class ShellCommands {
    private final LoggingApp app;

    ShellCommands(LoggingApp app) {
        this.app = app;
    }

    @Descriptor(value="Start logging all sensor values that are not configured for logging yet")
    public int logAllSensors() {
        int cnt = this.app.logAllSensors();
        System.out.println("Started logging of " + cnt + " new resources");
        return cnt;
    }

    @Descriptor(value="Start logging all actor setpoints that are not configured for logging yet")
    public int logAllActors() {
        int cnt = this.app.logAllActors();
        System.out.println("Started logging of " + cnt + " new resources");
        return cnt;
    }

    @Descriptor(value="Activate logging for a specific resource")
    public boolean startLogging(@Descriptor(value="The resource path") String path) {
        return this.app.activateLogging(path);
    }

    @Descriptor(value="Deactivate logging for a specific resource")
    public boolean stopLogging(@Descriptor(value="The resource path") String path) {
        return this.app.stopLogging(path);
    }

    @Descriptor(value="Get all logged resources")
    public Collection<Resource> getLoggedResources() {
        return this.app.getLoggedResources();
    }

    @Descriptor(value="Check if logging is enabled for a specific resource")
    public boolean isLoggingActive(@Descriptor(value="The resource path") String path) {
        return this.app.isLoggingActive(path);
    }

    @Descriptor(value="Return the logging configuration for a specific resource")
    public RecordedDataConfiguration getLoggingConfig(@Descriptor(value="The resource path") String path) {
        return this.app.getLoggingConfiguration(path);
    }
}

