/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.apps.sensor.logging;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.Resource;
import org.ogema.core.model.SimpleResource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.model.actors.Actor;
import org.ogema.model.sensors.Sensor;
import org.ogema.model.smartgriddata.Price;
import org.ogema.tools.grafana.base.InfluxFake;

@Component(specVersion="1.2", immediate=true)
@Service(value={Application.class})
public class GrafanaLogging
implements Application,
ResourceDemandListener<SimpleResource> {
    protected OgemaLogger logger;
    protected ApplicationManager am;
    protected ResourceManagement rm;
    protected ResourceAccess ra;
    protected List<Class<? extends Resource>> resourceTypes;
    protected Map<String, Map> panels;
    protected long updateInterval = 5000L;
    protected InfluxFake infl;
    private String webResourceBrowserPath;
    private String servletPath;

    public void start(ApplicationManager am) {
        this.am = am;
        this.logger = am.getLogger();
        this.rm = am.getResourceManagement();
        this.ra = am.getResourceAccess();
        this.logger.debug("Grafana logging app started", (Object)this.getClass().getName());
        String webResourcePackagePath = "org/ogema/apps/sensor/logging/grafana-1.9.1";
        String appNameLowerCase = "SensorLogging".toLowerCase();
        this.webResourceBrowserPath = "/ogema/" + appNameLowerCase;
        am.getWebAccessManager().registerWebResource(this.webResourceBrowserPath, webResourcePackagePath);
        this.resourceTypes = new ArrayList<Class<? extends Resource>>();
        this.panels = new LinkedHashMap<String, Map>();
        this.infl = new InfluxFake(am, this.panels, this.updateInterval);
        this.infl.setStrictMode(true);
        this.servletPath = "/apps/ogema/" + appNameLowerCase + "/fake_influxdb/series";
        am.getWebAccessManager().registerWebResource(this.servletPath, (Servlet)this.infl);
        this.ra.addResourceDemand(SimpleResource.class, (ResourceDemandListener)this);
    }

    public void stop(Application.AppStopReason reason) {
        this.am.getWebAccessManager().unregisterWebResource(this.webResourceBrowserPath);
        this.am.getWebAccessManager().unregisterWebResource(this.servletPath);
        this.ra.removeResourceDemand(SimpleResource.class, (ResourceDemandListener)this);
    }

    public List<Class<? extends Resource>> getResourceTypes() {
        return this.resourceTypes;
    }

    public void resourceAvailable(SimpleResource resource) {
        Resource res = resource.getParent();
        if (res == null || !(res instanceof Sensor) && !(res instanceof Actor) && !(res instanceof Price)) {
            return;
        }
        Class type = res.getResourceType();
        if (!this.resourceTypes.contains(type)) {
            this.resourceTypes.add(type);
            LinkedHashMap<String, Class> rowPanels = new LinkedHashMap<String, Class>();
            rowPanels.put(type.getSimpleName(), type);
            this.panels.put(type.getSimpleName(), rowPanels);
            this.infl.setPanels(this.panels);
        }
    }

    public void resourceUnavailable(SimpleResource resource) {
    }
}

