/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.channelmapperv2.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.ogema.channelmapperv2.config.ChannelMapperConfigPattern;
import org.ogema.channelmapperv2.config.ChannelMapperConfiguration;
import org.ogema.channelmapperv2.impl.ChannelMapperImpl;
import org.ogema.channelmapperv2.impl.ChannelMapperUtil;
import org.ogema.core.channelmanager.ChannelAccess;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.ChannelEventListener;
import org.ogema.core.channelmanager.EventType;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.SampledValueContainer;
import org.ogema.core.channelmanager.measurements.BooleanValue;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.IntegerValue;
import org.ogema.core.channelmanager.measurements.LongValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.ValueResource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.tools.resource.util.ValueResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelController
implements ResourceValueListener<SingleValueResource>,
ChannelEventListener,
Runnable {
    private static final long MAX_DELAY = 900000L;
    final ChannelMapperConfigPattern pattern;
    private volatile ChannelConfiguration channelConfiguration;
    private final Logger logger;
    private final ChannelAccess ca;
    final ChannelLocator channelLocator;
    private final ChannelMapperImpl mapper;
    private volatile ScheduledExecutorService t;
    private volatile ScheduledFuture<?> openTask;
    private volatile long delay = 5000L;

    public ChannelController(ChannelMapperConfigPattern pattern, ChannelAccess ca, ChannelMapperImpl mapper) {
        this.pattern = pattern;
        this.ca = ca;
        this.logger = mapper.logger;
        this.mapper = mapper;
        this.channelLocator = ChannelMapperUtil.getChannelLocator(pattern.channelLocator);
        this.run();
    }

    @Override
    public void run() {
        if (!((ChannelMapperConfiguration)this.pattern.model).isActive()) {
            return;
        }
        try {
            ChannelConfiguration.Direction direction = ChannelConfiguration.Direction.valueOf((String)this.pattern.direction.getValue());
            long samplingPeriod = this.pattern.samplingInterval.isActive() ? this.pattern.samplingInterval.getValue() : 60000L;
            this.channelConfiguration = this.ca.addChannel(this.channelLocator, direction, samplingPeriod);
            if (direction == ChannelConfiguration.Direction.DIRECTION_OUTPUT || direction == ChannelConfiguration.Direction.DIRECTION_INOUT) {
                this.pattern.target.addValueListener((ResourceValueListener)this);
            }
            if (direction == ChannelConfiguration.Direction.DIRECTION_INPUT || direction == ChannelConfiguration.Direction.DIRECTION_INOUT) {
                this.ca.registerUpdateListener(Collections.singletonList(this.channelConfiguration), (ChannelEventListener)this);
            }
            ((BooleanResource)this.pattern.registrationSuccessful.create()).setValue(true);
            this.pattern.registrationSuccessful.activate(false);
            this.t = null;
            this.openTask = null;
        }
        catch (ChannelAccessException cae) {
            if (!((ChannelMapperConfiguration)this.pattern.model).isActive()) {
                return;
            }
            if (this.delay < 900000L) {
                this.delay *= 2L;
                if (this.delay > 900000L) {
                    this.delay = 900000L;
                }
            }
            this.logger.warn("Channel registration failed: {}. Trying again in {}s.", new Object[]{this.channelLocator, this.delay / 1000L, cae});
            ((BooleanResource)this.pattern.registrationSuccessful.create()).setValue(false);
            this.pattern.registrationSuccessful.activate(false);
            if (this.channelConfiguration != null) {
                this.ca.deleteChannel(this.channelConfiguration);
            }
            if (this.t == null) {
                this.t = this.mapper.getTimer();
            }
            try {
                this.openTask = this.t.schedule(this, this.delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                this.t = null;
                this.openTask = null;
            }
        }
    }

    public void resourceChanged(SingleValueResource resource) {
        float factor = 1.0f;
        float offset = 0.0f;
        if (this.pattern.scalingFactor.isActive()) {
            factor = this.pattern.scalingFactor.getValue();
        }
        if (this.pattern.valueOffset.isActive()) {
            offset = this.pattern.valueOffset.getValue();
        }
        try {
            this.ca.setChannelValue(this.channelConfiguration, ChannelController.transformBack(resource, factor, offset));
        }
        catch (ChannelAccessException e) {
            this.logger.error("Could not set new value for channel " + this.channelConfiguration + ", resource " + resource, (Throwable)e);
        }
    }

    public void channelEvent(EventType type, List<SampledValueContainer> channels) {
        this.logger.trace("Channel event for {}", (Object)this.pattern.target);
        for (SampledValueContainer container : channels) {
            if (!container.getChannelLocator().equals((Object)this.channelConfiguration.getChannelLocator())) continue;
            float factor = 1.0f;
            float offset = 0.0f;
            if (this.pattern.scalingFactor.isActive()) {
                factor = this.pattern.scalingFactor.getValue();
            }
            if (this.pattern.valueOffset.isActive()) {
                offset = this.pattern.valueOffset.getValue();
            }
            Value value = ChannelController.transform(container.getSampledValue().getValue(), factor, offset);
            ValueResourceUtils.setValue((SingleValueResource)this.pattern.target, (Value)value);
            this.pattern.target.activate(false);
        }
    }

    void close() {
        ScheduledFuture<?> openTask;
        try {
            this.pattern.target.removeValueListener((ResourceValueListener)this);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ChannelMapperImpl.class).warn("Error closing channel controller", (Throwable)e);
        }
        if (this.channelConfiguration != null) {
            try {
                this.ca.unregisterUpdateListener(Collections.singletonList(this.channelConfiguration), (ChannelEventListener)this);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ChannelMapperImpl.class).warn("Error closing channel controller", (Throwable)e);
            }
            try {
                this.ca.deleteChannel(this.channelConfiguration);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ChannelMapperImpl.class).warn("Error closing channel controller", (Throwable)e);
            }
        }
        if ((openTask = this.openTask) != null) {
            openTask.cancel(true);
        }
        this.openTask = null;
        this.t = null;
    }

    private static Value transform(Value in, float factor, float offset) {
        if (in instanceof FloatValue) {
            return new FloatValue(in.getFloatValue() * factor + offset);
        }
        if (in instanceof IntegerValue) {
            return new IntegerValue(in.getIntegerValue() * (int)factor + (int)offset);
        }
        if (in instanceof LongValue) {
            return new LongValue(in.getLongValue() * (long)factor + (long)offset);
        }
        if (in instanceof BooleanValue) {
            return new BooleanValue(in.getBooleanValue() && factor >= 0.0f);
        }
        return in;
    }

    private static Value transformBack(SingleValueResource in, float factor, float offset) {
        Object value = ValueResourceUtils.getValue((ValueResource)in);
        if (in instanceof FloatResource) {
            return new FloatValue((((Float)value).floatValue() - offset) / factor);
        }
        if (in instanceof IntegerResource) {
            return new IntegerValue(((Integer)value - (int)offset) / (int)factor);
        }
        if (in instanceof TimeResource) {
            return new LongValue(((Long)value - (long)offset) / (long)factor);
        }
        if (in instanceof BooleanResource) {
            return new BooleanValue((Boolean)value != false && factor >= 0.0f);
        }
        throw new IllegalArgumentException("Unsupported resource type " + in.getResourceType().getName());
    }
}

