/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.channelmapperv2.impl;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.ogema.channelmapperv2.ChannelMapper;
import org.ogema.channelmapperv2.config.ChannelMapperConfigPattern;
import org.ogema.channelmapperv2.config.ChannelMapperConfiguration;
import org.ogema.channelmapperv2.impl.ChannelController;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccess;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.CompoundResourceEvent;
import org.ogema.core.resourcemanager.pattern.PatternChangeListener;
import org.ogema.core.resourcemanager.pattern.PatternListener;
import org.ogema.core.resourcemanager.pattern.ResourcePattern;
import org.ogema.core.resourcemanager.transaction.ResourceTransaction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(immediate=true)
@Service(value={Application.class})
public class ChannelMapperImpl
implements Application,
ChannelMapper,
PatternListener<ChannelMapperConfigPattern>,
PatternChangeListener<ChannelMapperConfigPattern> {
    final ConcurrentMap<String, ChannelController> resourceMappings = new ConcurrentHashMap<String, ChannelController>();
    private final ConcurrentMap<ChannelLocator, ChannelController> channelMappings = new ConcurrentHashMap<ChannelLocator, ChannelController>();
    private volatile ResourceList<ChannelMapperConfiguration> configs;
    protected volatile OgemaLogger logger;
    private volatile ApplicationManager appMan;
    private volatile ChannelAccess ca;
    private volatile WeakReference<ScheduledExecutorService> timer = null;
    private volatile BundleContext ctx;
    private ServiceRegistration<ChannelMapper> sreg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScheduledExecutorService getTimer() {
        ScheduledExecutorService t;
        WeakReference<ScheduledExecutorService> timer = this.timer;
        if (timer != null && (t = (ScheduledExecutorService)timer.get()) != null) {
            return t;
        }
        ChannelMapperImpl channelMapperImpl = this;
        synchronized (channelMapperImpl) {
            timer = this.timer;
            if (timer != null && (t = (ScheduledExecutorService)timer.get()) != null) {
                return t;
            }
            t = Executors.newSingleThreadScheduledExecutor();
            this.timer = new WeakReference<ScheduledExecutorService>(t);
            return t;
        }
    }

    @Override
    public void mapChannelToResource(ChannelLocator channel, SingleValueResource target, ChannelConfiguration.Direction direction, long samplingPeriod, float scalingFactor, float valueOffset) {
        Objects.requireNonNull(this.ca);
        Objects.requireNonNull(channel);
        Objects.requireNonNull(target);
        Objects.requireNonNull(direction);
        ChannelMapperConfiguration config = (ChannelMapperConfiguration)this.configs.add();
        ResourceTransaction trans = this.appMan.getResourceAccess().createResourceTransaction();
        trans.create((Resource)config.channelLocator());
        trans.create((Resource)config.channelLocator().driverId());
        trans.create((Resource)config.channelLocator().interfaceId());
        trans.create((Resource)config.channelLocator().deviceAddress());
        trans.create((Resource)config.channelLocator().parameters());
        trans.create((Resource)config.channelLocator().channelAddress());
        trans.setString(config.channelLocator().driverId(), channel.getDeviceLocator().getDriverName());
        trans.setString(config.channelLocator().deviceAddress(), channel.getDeviceLocator().getDeviceAddress());
        trans.setString(config.channelLocator().interfaceId(), channel.getDeviceLocator().getInterfaceName());
        trans.setString(config.channelLocator().parameters(), channel.getDeviceLocator().getParameters());
        trans.setString(config.channelLocator().channelAddress(), channel.getChannelAddress());
        trans.setAsReference((Resource)config.target(), (Resource)target);
        trans.create((Resource)config.direction());
        trans.setString(config.direction(), direction.name());
        trans.create((Resource)config.samplingInterval());
        trans.setTime(config.samplingInterval(), samplingPeriod);
        trans.create((Resource)config.scalingFactor());
        trans.setFloat(config.scalingFactor(), scalingFactor);
        trans.create((Resource)config.valueOffset());
        trans.setFloat(config.valueOffset(), valueOffset);
        trans.activate((Resource)config, false, true);
        trans.commit();
    }

    @Override
    public void unmapChannel(ChannelLocator channel) {
        this.unmapChannel(channel, null);
    }

    @Override
    public void unmapChannel(ChannelLocator channel, SingleValueResource target) {
        ChannelController cc = (ChannelController)this.channelMappings.get(channel);
        if (cc == null) {
            this.logger.warn("Channel not found, cannot remove it: {}", (Object)channel);
            return;
        }
        if (target != null && !cc.pattern.target.equalsLocation((Resource)target)) {
            return;
        }
        ((ChannelMapperConfiguration)cc.pattern.model).delete();
    }

    public void patternAvailable(ChannelMapperConfigPattern pattern) {
        this.logger.info("New channel mapper configuration found: {}", (Object)pattern.model);
        this.newPattern(pattern);
        this.appMan.getResourcePatternAccess().addPatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this, ChannelMapperConfigPattern.class);
    }

    private void newPattern(ChannelMapperConfigPattern pattern) {
        ChannelController cc;
        String path = ((ChannelMapperConfiguration)pattern.model).getPath();
        if (this.resourceMappings.containsKey(path)) {
            this.logger.warn("Got a second callback for an existing mapping configuration " + pattern.model);
            return;
        }
        try {
            cc = new ChannelController(pattern, this.ca, this);
        }
        catch (SecurityException e) {
            this.logger.warn("Channel configuration could not be created, permission denied: {}", (Object)pattern.model, (Object)e);
            ((ChannelMapperConfiguration)pattern.model).delete();
            return;
        }
        this.resourceMappings.put(path, cc);
        this.channelMappings.put(cc.channelLocator, cc);
    }

    public void patternUnavailable(ChannelMapperConfigPattern pattern) {
        this.logger.info("Channel mapper configuration removed: {}", (Object)pattern.model);
        this.appMan.getResourcePatternAccess().removePatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this);
        this.patternGone(pattern);
    }

    private void patternGone(ChannelMapperConfigPattern pattern) {
        ChannelController cc = (ChannelController)this.resourceMappings.remove(((ChannelMapperConfiguration)pattern.model).getPath());
        if (cc == null) {
            return;
        }
        cc.close();
        this.channelMappings.remove(cc.channelLocator);
    }

    public void patternChanged(ChannelMapperConfigPattern instance, List<CompoundResourceEvent<?>> changes) {
        this.logger.info("Channel mapper configuration has changed: {}", (Object)instance.model);
        this.patternGone(instance);
        this.newPattern(instance);
    }

    @Activate
    protected void activate(BundleContext ctx) {
        this.ctx = ctx;
    }

    public void start(ApplicationManager appManager) {
        Objects.requireNonNull(this.ctx);
        this.logger = appManager.getLogger();
        this.appMan = appManager;
        this.ca = appManager.getChannelAccess();
        this.configs = (ResourceList)appManager.getResourceManagement().createResource("channelMapperConfigurations", ResourceList.class);
        this.configs.setElementType(ChannelMapperConfiguration.class);
        this.configs.activate(false);
        appManager.getResourcePatternAccess().addPatternDemand(ChannelMapperConfigPattern.class, (PatternListener)this, AccessPriority.PRIO_LOWEST);
        this.sreg = this.ctx.registerService(ChannelMapper.class, (Object)this, null);
    }

    public void stop(Application.AppStopReason reason) {
        WeakReference<ScheduledExecutorService> timer;
        ServiceRegistration<ChannelMapper> sreg = this.sreg;
        if (sreg != null) {
            try {
                sreg.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sreg = null;
        }
        if (this.appMan != null) {
            this.appMan.getResourcePatternAccess().removePatternDemand(ChannelMapperConfigPattern.class, (PatternListener)this);
        }
        if ((timer = this.timer) != null) {
            ScheduledExecutorService t = (ScheduledExecutorService)timer.get();
            if (t != null) {
                t.shutdownNow();
            }
            this.timer = null;
        }
        for (ChannelController cc : this.resourceMappings.values()) {
            if (this.appMan != null) {
                this.appMan.getResourcePatternAccess().removePatternChangeListener((ResourcePattern)cc.pattern, (PatternChangeListener)this);
            }
            cc.close();
        }
        this.logger = null;
        this.appMan = null;
        this.ca = null;
        this.resourceMappings.clear();
        this.channelMappings.clear();
        this.configs = null;
    }
}

