/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.channelmapperv2.impl;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Descriptor;
import org.ogema.channelmapperv2.ChannelMapper;
import org.ogema.channelmapperv2.config.ChannelMapperConfiguration;
import org.ogema.channelmapperv2.impl.ChannelController;
import org.ogema.channelmapperv2.impl.ChannelMapperImpl;

@Descriptor(value="OGEMA channel mapper commands")
@Component(specVersion="1.2", immediate=true)
@Properties(value={@Property(name="osgi.command.scope", value={"ChannelMapper"}), @Property(name="osgi.command.function", value={"listConfigs"})})
@Service(value={ShellCommands.class})
public class ShellCommands {
    @Reference
    private ChannelMapper channelMapper;

    @Descriptor(value="list channel mapper configurations")
    public void listConfigs() {
        System.out.println("Channel mapper configurations");
        for (ChannelController cc : ((ChannelMapperImpl)this.channelMapper).resourceMappings.values()) {
            ShellCommands.printChannelMapping(cc);
        }
        System.out.println();
    }

    private static void printChannelMapping(ChannelController cc) {
        System.out.println("  Configuration " + ((ChannelMapperConfiguration)cc.pattern.model).getLocation());
        System.out.println("    Resource: " + cc.pattern.target.getLocationResource());
        System.out.println("    Channel: " + cc.channelLocator);
        System.out.println("    Initialisation successful: " + (cc.pattern.registrationSuccessful.isActive() && cc.pattern.registrationSuccessful.getValue()));
    }

    protected void bindChannelMapper(ChannelMapper channelMapper) {
        this.channelMapper = channelMapper;
    }

    protected void unbindChannelMapper(ChannelMapper channelMapper) {
        if (this.channelMapper == channelMapper) {
            this.channelMapper = null;
        }
    }
}

