/**
 * Copyright 2011-2018 Fraunhofer-Gesellschaft zur Förderung der angewandten Wissenschaften e.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ogema.driver.generic_xbee;

import org.ogema.core.application.Application;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

/**
 * @author Zekeriya Mansuroglu
 *
 */
public class Activator implements BundleActivator {

	private ServiceRegistration<?> serviceRegistration;
	private GenericXbeeZbDriver driver;
	private ShellCommands shell;
	volatile boolean running;

	private final Logger logger = org.slf4j.LoggerFactory.getLogger("generic_xbee_hl");

	@Override
	public void start(BundleContext context) throws Exception {
		driver = new GenericXbeeZbDriver();
		Application application = driver;
		serviceRegistration = context.registerService(Application.class.getName(), application, null);
		shell = new ShellCommands(driver, context);
		running = true;

		Thread scan = new Thread(new Runnable() {

			public void run() {
				int scantimes = 5;
				String scan = System.getProperty("org.ogema.driver.xbee.scannetwork");
				boolean forever = false;
				if (scan != null)
					forever = true;
				while (running) {
					if (!forever && scantimes >= 0)
						scantimes--;
					if (!forever && scantimes < 0)
						running = false;
					try {
						Thread.sleep(13000);
						logger.debug("Device scan started ...");
						shell.deviceScan(null);
						logger.debug(".. device scan finished.");
					} catch (Throwable e) {
						logger.debug("", e);
					}
				}
			}
		});
		scan.setName("generic-xbee-hld-scanDevices");
		scan.start();
	}

	@Override
	public void stop(BundleContext context) throws Exception {
		running = false;
		serviceRegistration.unregister();
	}

}
