/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.generic_xbee;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccess;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.ChannelEventListener;
import org.ogema.core.channelmanager.EventType;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.driverspi.SampledValueContainer;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.driver.generic_xbee.GenericXbeeZbConfig;
import org.ogema.driver.generic_xbee.GenericXbeeZbDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericXbeeZbDevice
implements ChannelEventListener {
    private final Logger logger = LoggerFactory.getLogger((String)"generic_xbee_hl");
    protected final GenericXbeeZbConfig configurationResource;
    protected final ApplicationManager appManager;
    protected ChannelConfiguration channelLocator;
    protected long timeout;
    protected DeviceLocator deviceLocator;
    protected ResourceManagement resourceManager;
    protected GenericXbeeZbDriver driver;
    protected final ChannelAccess channelAccess;
    private List<ChannelConfiguration> channelList;

    public GenericXbeeZbDevice(GenericXbeeZbDriver driver, ApplicationManager appManager, GenericXbeeZbConfig config) {
        this.appManager = appManager;
        this.channelList = new ArrayList<ChannelConfiguration>();
        this.channelAccess = appManager.getChannelAccess();
        this.resourceManager = appManager.getResourceManagement();
        this.configurationResource = config;
        this.configurationResource.resourceName = this.configurationResource.resourceName.replace("-", "");
        this.driver = driver;
        this.deviceLocator = new DeviceLocator(config.driverId, config.interfaceId, config.deviceAddress, config.deviceParameters);
        this.unifyResourceName(this.configurationResource);
    }

    public GenericXbeeZbDevice(GenericXbeeZbDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        this.appManager = appManager;
        this.channelAccess = appManager.getChannelAccess();
        this.channelList = new ArrayList<ChannelConfiguration>();
        this.resourceManager = appManager.getResourceManagement();
        this.configurationResource = new GenericXbeeZbConfig();
        this.driver = driver;
        this.configurationResource.interfaceId = deviceLocator.getInterfaceName();
        this.configurationResource.deviceAddress = deviceLocator.getDeviceAddress();
        this.configurationResource.driverId = deviceLocator.getDriverName();
        this.configurationResource.deviceParameters = deviceLocator.getParameters();
        String[] splitStringArray = deviceLocator.getParameters().split(":");
        this.configurationResource.resourceName = splitStringArray[1];
        this.deviceLocator = deviceLocator;
        this.unifyResourceName(this.configurationResource);
    }

    public void channelEvent(EventType type, List<SampledValueContainer> channels) {
        for (SampledValueContainer c : channels) {
            try {
                this.updateValues(c.getSampledValue().getValue());
            }
            catch (Throwable e) {
                this.logger.error("Changed channel value could not be read");
                e.printStackTrace();
            }
        }
    }

    protected ChannelLocator createChannelLocator(String channelAddress) {
        return new ChannelLocator(channelAddress, this.deviceLocator);
    }

    public abstract void addChannel(GenericXbeeZbConfig var1);

    public abstract void updateValues(Value var1);

    protected void addToUpdateListener(ChannelConfiguration channelConfiguration) throws ChannelAccessException {
        this.channelList.add(channelConfiguration);
        this.channelAccess.registerUpdateListener(this.channelList, (ChannelEventListener)this);
    }

    protected void removeFromUpdateListener(ChannelConfiguration channelConfiguration) {
        this.channelList.remove(channelConfiguration);
        this.logger.debug("channelList size: " + this.channelList.size());
        this.channelAccess.unregisterUpdateListener(this.channelList, (ChannelEventListener)this);
    }

    public abstract void unifyResourceName(GenericXbeeZbConfig var1);

    public abstract JSONObject packValuesAsJSON();
}

