/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.generic_xbee;

import java.util.HashMap;
import java.util.Map;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccess;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.ChannelEventListener;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.driverspi.DeviceScanListener;
import org.ogema.driver.generic_xbee.GenericXbeeZbConfig;
import org.ogema.driver.generic_xbee.GenericXbeeZbDevice;
import org.ogema.driver.generic_xbee.devices.PikkertonZbs110V2Device;
import org.ogema.driver.generic_xbee.devices.PikkertonZbs122Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericXbeeZbDriver
implements Application,
DeviceScanListener {
    private final Logger logger = LoggerFactory.getLogger((String)"generic_xbee_hl");
    ApplicationManager appManager;
    ChannelAccess channelAccess;
    private final Map<String, GenericXbeeZbDevice> devices = new HashMap<String, GenericXbeeZbDevice>();
    public final Map<String, ChannelConfiguration> channelMap = new HashMap<String, ChannelConfiguration>();
    private int resourceNameCounter = 0;
    ChannelEventListener channelEventListener;

    public void start(ApplicationManager appManager) {
        this.appManager = appManager;
        this.channelAccess = appManager.getChannelAccess();
        this.logger.info("GenericXbeeZbDriver started");
    }

    public void stop(Application.AppStopReason reason) {
        for (ChannelConfiguration chConf : this.channelMap.values()) {
            this.channelAccess.deleteChannel(chConf);
        }
    }

    public void resourceAvailable(GenericXbeeZbConfig config) {
        if (!this.devices.containsKey(config.interfaceId + ":" + config.deviceAddress)) {
            String channelAddress = config.channelAddress;
            String[] splitAddress = channelAddress.split(":");
            switch (splitAddress[2]) {
                case "HA SENSORKNOTEN": {
                    break;
                }
                case "ZBS-122": {
                    PikkertonZbs122Device device = new PikkertonZbs122Device(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    this.logger.debug("Channellocator: " + device.channelLocator.toString());
                    break;
                }
                case "ZBS-110V2": {
                    PikkertonZbs110V2Device device = new PikkertonZbs110V2Device(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    this.logger.debug("Channellocator: " + device.channelLocator.toString());
                }
            }
        }
    }

    public Map<String, GenericXbeeZbDevice> getDevices() {
        return this.devices;
    }

    public void resourceUnavailable(GenericXbeeZbConfig config) {
        String key = config.driverId + ":" + config.interfaceId + ":" + config.deviceAddress + ":" + config.channelAddress;
        GenericXbeeZbDevice device = this.devices.remove(key);
        if (device != null) {
            this.logger.info("delete: " + device.channelLocator);
            this.channelAccess.deleteChannel(device.channelLocator);
        }
    }

    public int getResourceNameCounter() {
        return this.resourceNameCounter++;
    }

    public void deviceFound(DeviceLocator deviceLocator) {
        GenericXbeeZbDevice device = null;
        try {
            String[] splitStringArray = deviceLocator.getParameters().split(":");
            if (this.devices.containsKey(deviceLocator.getInterfaceName() + ":" + deviceLocator.getDeviceAddress().toUpperCase())) {
                return;
            }
            if (splitStringArray[0].equals("XBee")) {
                switch (splitStringArray[1]) {
                    case "HA SENSORKNOTEN": {
                        break;
                    }
                    case "ZBS-122": {
                        device = new PikkertonZbs122Device(this, this.appManager, deviceLocator);
                        break;
                    }
                    case "ZBS-110V2": {
                        device = new PikkertonZbs110V2Device(this, this.appManager, deviceLocator);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (device != null) {
            this.logger.info("\nDevice found: " + deviceLocator.getDeviceAddress() + "\n" + deviceLocator.getParameters());
            this.devices.put(deviceLocator.getInterfaceName() + ":" + deviceLocator.getDeviceAddress().toUpperCase(), device);
        }
    }

    public void finished(boolean success, Exception e) {
        this.logger.debug("Generic XBee Driver: DeviceScan finished!");
    }

    public void progress(float ratio) {
    }
}

