/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.generic_xbee;

import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.DeviceScanListener;
import org.ogema.driver.generic_xbee.GenericXbeeZbConfig;
import org.ogema.driver.generic_xbee.GenericXbeeZbDevice;
import org.ogema.driver.generic_xbee.GenericXbeeZbDriver;
import org.ogema.driverconfig.HLDriverInterface;
import org.osgi.framework.BundleContext;

public class ShellCommands
implements HLDriverInterface {
    private BundleContext context = null;
    private GenericXbeeZbDriver driver = null;

    public ShellCommands(GenericXbeeZbDriver driver, BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("osgi.command.scope", "xbhl");
        props.put("osgi.command.function", new String[]{"showCreatedChannels", "createChannel", "deleteChannel", "readChannel", "deviceScan"});
        this.context = context;
        this.driver = driver;
        this.context.registerService(this.getClass().getName(), (Object)this, props);
        context.registerService(HLDriverInterface.class, (Object)this, null);
    }

    public void showCreatedChannels() {
        for (Map.Entry<String, ChannelConfiguration> mapEntry : this.driver.channelMap.entrySet()) {
            System.out.println(mapEntry.getKey() + ": " + mapEntry.getValue().getChannelLocator().toString());
        }
    }

    @Descriptor(value="Creates a new channel.")
    public void createChannel(@Descriptor(value="The interface ID/Port name.") String interfaceId, @Descriptor(value="The device address in form of 16Bit:EndpointID e. g. 0000:00.") String deviceAddress, @Descriptor(value="The channel address in form of ClusterId:Type:Id e. g. 0000:Attribute:0000.") String channelAddress, @Descriptor(value="The period in which the ChannelManager should try to request a new value. 0 for commands.") long timeout, @Descriptor(value="A name for the resource.") String resourceName, String deviceId) {
        GenericXbeeZbConfig config = new GenericXbeeZbConfig();
        config.interfaceId = interfaceId;
        config.deviceAddress = deviceAddress.toUpperCase();
        config.channelAddress = channelAddress.toUpperCase();
        config.timeout = timeout;
        config.resourceName = resourceName;
        config.deviceParameters = "";
        System.out.println(config.interfaceId + " " + config.deviceAddress + " " + config.channelAddress);
        this.driver.resourceAvailable(config);
    }

    @Descriptor(value="Deletes a channel.")
    public void deleteChannel(@Descriptor(value="The interface ID/Port name.") String interfaceId, @Descriptor(value="The device address in form of 16Bit:EndpointID e. g. 0000:00.") String deviceAddress, @Descriptor(value="The channel address in form of ClusterId:Type:Id e. g. 0000:Attribute:0000.") String channelAddress) {
        GenericXbeeZbConfig config = new GenericXbeeZbConfig();
        config.interfaceId = interfaceId;
        config.deviceAddress = deviceAddress.toUpperCase();
        config.channelAddress = channelAddress.toUpperCase();
        config.deviceParameters = "";
        this.driver.resourceUnavailable(config);
    }

    @Descriptor(value="Read from a channel.")
    public JSONObject readChannel(@Descriptor(value="The interface ID/Port name.") String interfaceId, @Descriptor(value="The device address in form of 16Bit:EndpointID e. g. 0000:00.") String deviceAddress, @Descriptor(value="The channel address in form of ClusterId:Type:Id e. g. 0000:Attribute:0000.") String channelAddress) {
        return this.updateValues(this.driver.getDevices().get("xbee-driver:" + interfaceId + ":" + deviceAddress.toUpperCase() + ":" + channelAddress.toUpperCase()));
    }

    public void deviceScan(@Descriptor(value="The interface ID/Port name.") String interfaceId) throws Throwable {
        if (this.driver.appManager != null) {
            this.driver.appManager.getChannelAccess().discoverDevices("xbee-driver", interfaceId, null, (DeviceScanListener)this.driver);
        }
    }

    public void writeChannel(String interfaceId, String deviceAddress, String channelAddress, String writeValue) {
    }

    public JSONArray showCreatedChannels(String deviceAddress) {
        return null;
    }

    public String whichID() {
        return "generic-xbee-zb";
    }

    JSONObject updateValues(GenericXbeeZbDevice dev) {
        return dev.packValuesAsJSON();
    }
}

