/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.generic_xbee.devices;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.ByteArrayValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.units.ElectricCurrentResource;
import org.ogema.core.model.units.EnergyResource;
import org.ogema.core.model.units.FrequencyResource;
import org.ogema.core.model.units.PowerResource;
import org.ogema.core.model.units.VoltageResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.ResourceListener;
import org.ogema.driver.generic_xbee.GenericXbeeZbConfig;
import org.ogema.driver.generic_xbee.GenericXbeeZbDevice;
import org.ogema.driver.generic_xbee.GenericXbeeZbDriver;
import org.ogema.model.connections.ElectricityConnection;
import org.ogema.model.devices.sensoractordevices.SingleSwitchBox;
import org.ogema.model.sensors.ElectricCurrentSensor;
import org.ogema.model.sensors.ElectricFrequencySensor;
import org.ogema.model.sensors.ElectricPowerSensor;
import org.ogema.model.sensors.ElectricVoltageSensor;
import org.ogema.model.sensors.EnergyAccumulatedSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PikkertonZbs110V2Device
extends GenericXbeeZbDevice
implements ResourceListener {
    private final Logger logger = LoggerFactory.getLogger((String)"generic_xbee_hl");
    private static final String ZBS110_NAME = "ZBS110V2_";
    private final byte[] POW = new byte[]{80, 79, 87};
    private final byte[] FREQ = new byte[]{70, 82, 69, 81};
    private final byte[] VRMS = new byte[]{86, 82, 77, 83};
    private final byte[] IRMS = new byte[]{73, 82, 77, 83};
    private final byte[] LOAD = new byte[]{76, 79, 65, 68};
    private final byte[] WORK = new byte[]{87, 79, 82, 75};
    private byte[] identifier;
    private byte[] value;
    private ParsingState parsingState = ParsingState.VALUES_RECEIVED;
    private ByteBuffer rawValues;
    private ByteBuffer readValuesBuffer = ByteBuffer.allocate(128);
    private GenericXbeeZbConfig attributeConfig;
    private SingleSwitchBox zbs110Device;
    private BooleanResource onOff;
    private ElectricCurrentResource iRes;
    private VoltageResource vRes;
    private PowerResource pRes;
    private FrequencyResource fRes;
    private EnergyResource eRes;
    private BooleanResource isOn;
    private final byte[] powOn = new byte[]{83, 69, 84, 32, 80, 79, 87, 61, 79, 78, 10};
    private final byte[] powOff = new byte[]{83, 69, 84, 32, 80, 79, 87, 61, 79, 70, 70, 10};

    public PikkertonZbs110V2Device(GenericXbeeZbDriver driver, ApplicationManager appManager, GenericXbeeZbConfig configurationResource) {
        super(driver, appManager, configurationResource);
        this.attributeConfig = new GenericXbeeZbConfig();
        this.addChannel(configurationResource);
    }

    public PikkertonZbs110V2Device(GenericXbeeZbDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        super(driver, appManager, deviceLocator);
        this.attributeConfig = new GenericXbeeZbConfig();
        this.addMandatoryChannels();
    }

    private void addMandatoryChannels() {
        this.attributeConfig.driverId = this.configurationResource.driverId;
        this.attributeConfig.interfaceId = this.configurationResource.interfaceId;
        this.attributeConfig.deviceAddress = this.configurationResource.deviceAddress;
        this.attributeConfig.channelAddress = "0011:XBEE:ZBS-110V2";
        this.attributeConfig.timeout = -1L;
        this.attributeConfig.resourceName = this.configurationResource.resourceName + "_SwitchBox";
        this.addChannel(this.attributeConfig);
        this.zbs110Device = (SingleSwitchBox)this.resourceManager.createResource(this.attributeConfig.resourceName, SingleSwitchBox.class);
        this.zbs110Device.activate(true);
        this.onOff = (BooleanResource)this.zbs110Device.onOffSwitch().stateControl().create();
        this.onOff.activate(true);
        this.onOff.requestAccessMode(AccessMode.SHARED, AccessPriority.PRIO_HIGHEST);
        ElectricityConnection conn = (ElectricityConnection)this.zbs110Device.electricityConnection().create();
        conn.activate(true);
        ElectricCurrentSensor iSens = (ElectricCurrentSensor)conn.currentSensor().create();
        this.iRes = (ElectricCurrentResource)iSens.reading().create();
        this.iRes.activate(true);
        this.iRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricVoltageSensor vSens = (ElectricVoltageSensor)conn.voltageSensor().create();
        this.vRes = (VoltageResource)vSens.reading().create();
        this.vRes.activate(true);
        this.vRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricPowerSensor pSens = (ElectricPowerSensor)conn.powerSensor().create();
        this.pRes = (PowerResource)pSens.reading().create();
        this.pRes.activate(true);
        this.pRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricFrequencySensor fSens = (ElectricFrequencySensor)conn.frequencySensor().create();
        this.fRes = (FrequencyResource)fSens.reading().create();
        this.fRes.activate(true);
        this.fRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        EnergyAccumulatedSensor energy = (EnergyAccumulatedSensor)conn.energySensor().create();
        this.eRes = (EnergyResource)energy.reading().create();
        this.eRes.activate(true);
        this.eRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.isOn = (BooleanResource)this.zbs110Device.onOffSwitch().stateFeedback().create();
        this.isOn.activate(true);
        this.isOn.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.onOff.addResourceListener((ResourceListener)this, false);
    }

    @Override
    public void addChannel(GenericXbeeZbConfig config) {
        ChannelLocator channelLocator = this.createChannelLocator(config.channelAddress);
        ChannelConfiguration channelConfig = null;
        if (this.driver.channelMap.containsKey(config.resourceName)) {
            this.logger.error("resourceName already taken.");
            return;
        }
        try {
            channelConfig = this.channelAccess.addChannel(channelLocator, ChannelConfiguration.Direction.DIRECTION_INOUT, config.timeout);
            this.driver.channelMap.put(config.resourceName, channelConfig);
            this.addToUpdateListener(channelConfig);
        }
        catch (ChannelAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateValues(Value value) {
        this.rawValues = ByteBuffer.wrap(value.getByteArrayValue());
        this.parseValues();
    }

    private void parseValues() {
        PikkertonZbs110Values parsedValues = new PikkertonZbs110Values();
        int parsedCounter = 0;
        this.logger.debug("Raw values:");
        for (byte by : this.rawValues.array()) {
            System.out.print((char)by);
        }
        while (this.rawValues.position() < this.rawValues.limit()) {
            byte b = this.rawValues.get();
            ++parsedCounter;
            switch (this.parsingState) {
                case VALUES_RECEIVED: {
                    if (61 == b) {
                        this.readValuesBuffer.position(this.readValuesBuffer.position() - --parsedCounter);
                        this.identifier = new byte[parsedCounter];
                        this.readValuesBuffer.get(this.identifier, 0, parsedCounter);
                        this.parsingState = ParsingState.IDENTIFIER_PARSED;
                        parsedCounter = 0;
                        break;
                    }
                    this.readValuesBuffer.put(b);
                    break;
                }
                case IDENTIFIER_PARSED: {
                    if (10 == b) {
                        this.readValuesBuffer.position(this.readValuesBuffer.position() - --parsedCounter);
                        this.value = new byte[parsedCounter];
                        this.readValuesBuffer.get(this.value, 0, parsedCounter);
                        this.parsingState = ParsingState.VALUE_PARSED;
                    } else {
                        if (!(b >= 48 && b <= 57 || b == 46 || Arrays.equals(this.identifier, this.POW))) {
                            --parsedCounter;
                            break;
                        }
                        this.readValuesBuffer.put(b);
                        break;
                    }
                }
                case VALUE_PARSED: {
                    for (byte b1 : this.value) {
                        System.out.print((char)b1);
                    }
                    System.out.println();
                    if (Arrays.equals(this.identifier, this.POW)) {
                        if (78 == this.value[1]) {
                            parsedValues.pow = true;
                        } else if (this.value[1] == 70) {
                            parsedValues.pow = false;
                        }
                    } else if (Arrays.equals(this.identifier, this.FREQ)) {
                        parsedValues.freq = Float.parseFloat(new String(this.value));
                    } else if (Arrays.equals(this.identifier, this.VRMS)) {
                        parsedValues.vrms = Short.parseShort(new String(this.value));
                    } else if (Arrays.equals(this.identifier, this.IRMS)) {
                        parsedValues.irms = Short.parseShort(new String(this.value));
                    } else if (Arrays.equals(this.identifier, this.LOAD)) {
                        parsedValues.load = Integer.parseInt(new String(this.value));
                    } else if (Arrays.equals(this.identifier, this.WORK)) {
                        parsedValues.work = Float.parseFloat(new String(this.value));
                    }
                    this.parsingState = ParsingState.VALUES_RECEIVED;
                    parsedCounter = 0;
                }
            }
        }
        this.identifier = null;
        this.value = null;
        this.readValuesBuffer.clear();
        this.logger.info("############ Pikkerton ZBS-110 values parsed ############");
        this.logger.info("Power: " + parsedValues.pow);
        this.logger.info("Frequency: " + parsedValues.freq);
        this.logger.info("Voltage: " + parsedValues.vrms);
        this.logger.info("Current: " + parsedValues.irms);
        this.logger.info("Load: " + parsedValues.load);
        this.logger.info("Energy: " + parsedValues.work);
        this.isOn.setValue(parsedValues.pow);
        this.iRes.setValue((float)parsedValues.irms);
        this.vRes.setValue((float)parsedValues.vrms);
        this.fRes.setValue(parsedValues.freq);
    }

    public void resourceChanged(Resource res) {
        this.logger.debug("onOff method call");
        if (!(res instanceof BooleanResource)) {
            return;
        }
        if (!res.getName().equals("onoff")) {
            return;
        }
        boolean onoffCommand = ((BooleanResource)res).getValue();
        ChannelConfiguration chConf = this.driver.channelMap.get(this.attributeConfig.resourceName);
        if (onoffCommand) {
            try {
                this.channelAccess.setChannelValue(chConf, (Value)new ByteArrayValue(this.powOn));
            }
            catch (ChannelAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.channelAccess.setChannelValue(chConf, (Value)new ByteArrayValue(this.powOff));
            }
            catch (ChannelAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void unifyResourceName(GenericXbeeZbConfig xbeeConfig) {
        xbeeConfig.resourceName = ZBS110_NAME + xbeeConfig.deviceAddress.replace(':', '_');
    }

    @Override
    public JSONObject packValuesAsJSON() {
        PikkertonZbs110Values parsedValues = new PikkertonZbs110Values();
        JSONObject parseValuesJSONObject = new JSONObject();
        try {
            parseValuesJSONObject.put("pow", parsedValues.pow);
            parseValuesJSONObject.put("freq", (double)parsedValues.freq);
            parseValuesJSONObject.put("vrms", (int)parsedValues.vrms);
            parseValuesJSONObject.put("irms", (int)parsedValues.irms);
            parseValuesJSONObject.put("load", parsedValues.load);
            parseValuesJSONObject.put("work", (double)parsedValues.work);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return parseValuesJSONObject;
    }

    class PikkertonZbs110Values {
        public boolean pow;
        public float freq;
        public short vrms;
        public short irms;
        public int load;
        public float work;

        PikkertonZbs110Values() {
        }
    }

    private static enum ParsingState {
        VALUES_RECEIVED,
        IDENTIFIER_PARSED,
        VALUE_PARSED;

    }
}

