/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.generic_xbee.devices;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.driver.generic_xbee.GenericXbeeZbConfig;
import org.ogema.driver.generic_xbee.GenericXbeeZbDevice;
import org.ogema.driver.generic_xbee.GenericXbeeZbDriver;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.model.sensors.HumiditySensor;
import org.ogema.model.sensors.TemperatureSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PikkertonZbs122Device
extends GenericXbeeZbDevice {
    private final Logger logger = LoggerFactory.getLogger((String)"generic_xbee_hl");
    private static final String ZBS122_NAME = "ZBS122_";
    private final byte[] TEM = new byte[]{84, 69, 77};
    private final byte[] HUM = new byte[]{72, 85, 77};
    private final byte[] BAT = new byte[]{66, 65, 84};
    private final byte[] UBAT = new byte[]{85, 66, 65, 84};
    private byte[] identifier;
    private byte[] value;
    private ParsingState parsingState = ParsingState.VALUES_RECEIVED;
    private ByteBuffer rawValues;
    private ByteBuffer readValuesBuffer = ByteBuffer.allocate(128);
    private GenericXbeeZbConfig attributeConfig = new GenericXbeeZbConfig();
    TemperatureResource tRes;
    FloatResource rHumidity;

    public PikkertonZbs122Device(GenericXbeeZbDriver driver, ApplicationManager appManager, GenericXbeeZbConfig config) {
        super(driver, appManager, config);
        this.addChannel(config);
    }

    public PikkertonZbs122Device(GenericXbeeZbDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        super(driver, appManager, deviceLocator);
        this.addMandatoryChannels();
    }

    private void addMandatoryChannels() {
        this.attributeConfig.driverId = this.configurationResource.driverId;
        this.attributeConfig.interfaceId = this.configurationResource.interfaceId;
        this.attributeConfig.deviceAddress = this.configurationResource.deviceAddress;
        this.attributeConfig.channelAddress = "0011:XBEE:ZBS-122";
        this.attributeConfig.timeout = -1L;
        this.attributeConfig.resourceName = this.configurationResource.resourceName + "_THSensor";
        this.addChannel(this.attributeConfig);
        SensorDevice zbs122Device = (SensorDevice)this.resourceManager.createResource(this.attributeConfig.resourceName, SensorDevice.class);
        zbs122Device.sensors().create();
        zbs122Device.sensors().activate(false);
        HumiditySensor hSens = (HumiditySensor)zbs122Device.sensors().addDecorator("humidity", HumiditySensor.class);
        this.rHumidity = (FloatResource)hSens.reading().create();
        this.rHumidity.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.rHumidity.activate(false);
        hSens.activate(false);
        TemperatureSensor tSens = (TemperatureSensor)zbs122Device.sensors().addDecorator("temperature", TemperatureSensor.class);
        this.tRes = (TemperatureResource)tSens.reading().create();
        this.tRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.tRes.activate(false);
        tSens.activate(false);
    }

    @Override
    public void addChannel(GenericXbeeZbConfig config) {
        ChannelLocator channelLocator = this.createChannelLocator(config.channelAddress);
        ChannelConfiguration channelConfig = null;
        if (this.driver.channelMap.containsKey(config.resourceName)) {
            this.logger.error("resourceName already taken.");
            return;
        }
        try {
            channelConfig = this.channelAccess.addChannel(channelLocator, ChannelConfiguration.Direction.DIRECTION_INOUT, config.timeout);
            this.driver.channelMap.put(config.resourceName, channelConfig);
            this.addToUpdateListener(channelConfig);
        }
        catch (ChannelAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateValues(Value value) {
        this.rawValues = ByteBuffer.wrap(value.getByteArrayValue());
        this.parseValues();
    }

    private void parseValues() {
        PikkertonZbs122Values parsedValues = new PikkertonZbs122Values();
        int parsedCounter = 0;
        while (this.rawValues.position() < this.rawValues.limit()) {
            byte b = this.rawValues.get();
            ++parsedCounter;
            switch (this.parsingState) {
                case VALUES_RECEIVED: {
                    if (61 == b) {
                        this.readValuesBuffer.position(this.readValuesBuffer.position() - --parsedCounter);
                        this.identifier = new byte[parsedCounter];
                        this.readValuesBuffer.get(this.identifier, 0, parsedCounter);
                        this.parsingState = ParsingState.IDENTIFIER_PARSED;
                        parsedCounter = 0;
                        break;
                    }
                    this.readValuesBuffer.put(b);
                    break;
                }
                case IDENTIFIER_PARSED: {
                    if (10 == b) {
                        this.readValuesBuffer.position(this.readValuesBuffer.position() - --parsedCounter);
                        this.value = new byte[parsedCounter];
                        this.readValuesBuffer.get(this.value, 0, parsedCounter);
                        this.parsingState = ParsingState.VALUE_PARSED;
                    } else {
                        if (!(b >= 48 && b <= 57 || b == 46 || Arrays.equals(this.identifier, this.BAT))) {
                            --parsedCounter;
                            break;
                        }
                        this.readValuesBuffer.put(b);
                        break;
                    }
                }
                case VALUE_PARSED: {
                    if (Arrays.equals(this.identifier, this.TEM)) {
                        parsedValues.tem = Float.parseFloat(new String(this.value));
                    } else if (Arrays.equals(this.identifier, this.HUM)) {
                        parsedValues.hum = Short.parseShort(new String(this.value));
                    } else if (Arrays.equals(this.identifier, this.BAT)) {
                        if (76 == this.value[0]) {
                            parsedValues.bat = false;
                        } else if (this.value[0] == 79) {
                            parsedValues.bat = true;
                        }
                    } else if (Arrays.equals(this.identifier, this.UBAT)) {
                        parsedValues.ubat = Float.parseFloat(new String(this.value));
                    }
                    this.parsingState = ParsingState.VALUES_RECEIVED;
                    parsedCounter = 0;
                }
            }
        }
        this.identifier = null;
        this.value = null;
        this.readValuesBuffer.clear();
        this.logger.info("############ Pikkerton ZBS-122 values parsed ############");
        this.logger.info("Temp: " + parsedValues.tem);
        this.logger.info("Hum: " + parsedValues.hum);
        this.logger.info("Bat: " + parsedValues.bat);
        this.logger.info("Ubat: " + parsedValues.ubat);
        this.tRes.setCelsius(parsedValues.tem);
        this.rHumidity.setValue((float)parsedValues.hum);
    }

    @Override
    public void unifyResourceName(GenericXbeeZbConfig xbeeConfig) {
        xbeeConfig.resourceName = ZBS122_NAME + xbeeConfig.deviceAddress.replace(':', '_');
    }

    @Override
    public JSONObject packValuesAsJSON() {
        PikkertonZbs122Values parsedValues = new PikkertonZbs122Values();
        JSONObject parseValuesJSONObject = new JSONObject();
        try {
            parseValuesJSONObject.put("tem", (double)parsedValues.tem);
            parseValuesJSONObject.put("hum", (int)parsedValues.hum);
            parseValuesJSONObject.put("bat", parsedValues.bat);
            parseValuesJSONObject.put("ubat", (double)parsedValues.ubat);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return parseValuesJSONObject;
    }

    class PikkertonZbs122Values {
        public float tem;
        public short hum;
        public boolean bat;
        public float ubat;

        PikkertonZbs122Values() {
        }
    }

    private static enum ParsingState {
        VALUES_RECEIVED,
        IDENTIFIER_PARSED,
        VALUE_PARSED;

    }
}

