/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.xmlrpc.XmlRpcException;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.drivers.homematic.xmlrpc.hl.HomeMaticDriver;
import org.ogema.drivers.homematic.xmlrpc.hl.Persistence;
import org.ogema.drivers.homematic.xmlrpc.hl.WriteAction;
import org.ogema.drivers.homematic.xmlrpc.hl.WriteScheduler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.api.HomeMaticConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.KeyChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.MaintenanceChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.MotionDetectorChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.PMSwitchDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.PowerMeterChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.ShutterContactChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.SwitchChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.ThermostatChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.channels.WeatherChannel;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmLogicInterface;
import org.ogema.drivers.homematic.xmlrpc.ll.HomeMaticClient;
import org.ogema.drivers.homematic.xmlrpc.ll.HomeMaticClientCli;
import org.ogema.drivers.homematic.xmlrpc.ll.HomeMaticService;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmBackend;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEventListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HomeMatic;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmConnection
implements HomeMaticConnection {
    private final ApplicationManager appman;
    private final ComponentContext ctx;
    private final Logger logger;
    private final HomeMaticDriver hmDriver;
    final int MAX_RETRIES = 5;
    private final Runnable initTask;
    protected long reInitTryTime = 120000L;
    public static final long MAX_REINITTRYTIME = 86400000L;
    private Thread initThread;
    HomeMaticService hm;
    HomeMatic client;
    final HmLogicInterface baseResource;
    ServiceRegistration<HomeMaticClientCli> commandLine;
    volatile Timer t;
    final WriteScheduler writer;
    final List<DeviceHandler> handlers;
    private final ResourceDemandListener<HmDevice> devResourceListener = new ResourceDemandListener<HmDevice>(){

        public void resourceAvailable(HmDevice t) {
            if (!HmConnection.getToplevelResource(t).equalsLocation((Resource)HmConnection.this.baseResource)) {
                return;
            }
            HmConnection.this.hmDriver.setupDevice(t);
        }

        public void resourceUnavailable(HmDevice t) {
        }
    };
    final ResourceValueListener<BooleanResource> installModeListener = new ResourceValueListener<BooleanResource>(){

        public void resourceChanged(BooleanResource t) {
            if (t.equals(HmConnection.this.baseResource.installationMode().stateControl())) {
                try {
                    boolean onOff = t.getValue();
                    HmConnection.this.client.setInstallMode(onOff, 900, 1);
                    int secondsRemaining = HmConnection.this.client.getInstallMode();
                    HmConnection.this.baseResource.installationMode().stateFeedback().setValue(secondsRemaining > 0);
                }
                catch (XmlRpcException ex) {
                    HmConnection.this.logger.error("could not activate install mode", (Throwable)ex);
                }
            } else if (t.equals(HmConnection.this.baseResource.installationMode().stateFeedback())) {
                boolean installModeOn = HmConnection.this.baseResource.installationMode().stateFeedback().getValue();
                HmConnection.this.logger.info("installation mode {}", (Object)(installModeOn ? "on" : "off"));
            }
        }
    };
    final TimerListener installModePolling = new TimerListener(){

        public void timerElapsed(Timer timer) {
            try {
                int secondsRemaining = HmConnection.this.client.getInstallMode();
                HmConnection.this.logger.debug("polled installation mode: {}s", (Object)secondsRemaining);
                HmConnection.this.baseResource.installationMode().stateFeedback().setValue(secondsRemaining > 0);
            }
            catch (XmlRpcException ex) {
                HmConnection.this.logger.error("could not poll HomeMatic client for installation mode state", (Throwable)ex);
            }
        }
    };

    public static Resource getToplevelResource(Resource r) {
        Resource res = r.getLocationResource();
        while (!res.isTopLevel()) {
            if ((res = res.getParent()) != null) continue;
            throw new IllegalStateException("This should never occur!");
        }
        return res;
    }

    public HmConnection(List<DeviceHandlerFactory> handlerFactories, final ApplicationManager appman, EventAdmin eventAdmin, ComponentContext ctx, final Logger logger, HomeMaticDriver hmDriver, final HmLogicInterface baseResource) {
        this.appman = appman;
        this.baseResource = baseResource;
        this.ctx = ctx;
        this.logger = logger;
        this.hmDriver = hmDriver;
        this.writer = new WriteScheduler(appman, eventAdmin);
        this.handlers = new ArrayList<DeviceHandler>();
        for (DeviceHandlerFactory fac : handlerFactories) {
            this.handlers.add(fac.createHandler(this));
        }
        this.handlers.add(new PMSwitchDevice(this));
        this.handlers.add(new MaintenanceChannel(this));
        this.handlers.add(new ThermostatChannel(this));
        this.handlers.add(new SwitchChannel(this));
        this.handlers.add(new PowerMeterChannel(this));
        this.handlers.add(new WeatherChannel(this));
        this.handlers.add(new ShutterContactChannel(this));
        this.handlers.add(new MotionDetectorChannel(this));
        this.handlers.add(new KeyChannel(this));
        this.initTask = new Runnable(){

            @Override
            public void run() {
                logger.debug("Starting Homematic init for ogema-" + baseResource.getName() + ", may block for 20sec");
                try {
                    HmConnection.this.hm.init(HmConnection.this.client, "ogema-" + baseResource.getName());
                }
                catch (XmlRpcException e) {
                    if (Thread.interrupted()) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    logger.error("could not start HomeMatic driver for config {}", (Object)baseResource.getPath());
                    logger.debug("Exception details:", (Throwable)e);
                    HmConnection.this.performInitThreadDelayed();
                    return;
                }
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    logger.error("Thread interrupted for config {}", (Object)baseResource.getPath());
                    return;
                }
                appman.getResourceAccess().addResourceDemand(HmDevice.class, HmConnection.this.devResourceListener);
                HmConnection.this.t = appman.createTimer(30000L, HmConnection.this.installModePolling);
                HmConnection.this.writer.start();
                logger.info("HomeMatic driver configured and registered according to config {}", (Object)baseResource.getPath());
            }
        };
    }

    @Override
    public void addEventListener(HmEventListener l) {
        this.hm.addEventListener(l);
    }

    @Override
    public void removeEventListener(HmEventListener l) {
        this.hm.removeEventListener(l);
    }

    @Override
    public <T> T getValue(String address, String value_key) throws IOException {
        try {
            return (T)this.client.getValue(address, value_key);
        }
        catch (XmlRpcException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void performSetValue(String address, String valueKey, Object value) {
        this.writer.addWriteAction(WriteAction.createSetValue(this.client, address, valueKey, value));
    }

    @Override
    public void performPutParamset(String address, String set, Map<String, Object> values) {
        this.writer.addWriteAction(WriteAction.createPutParamset(this.client, address, set, values));
    }

    @Override
    public void performAddLink(String sender, String receiver, String name, String description) {
        WriteAction writeAction = WriteAction.createAddLink(this.client, sender, receiver, name, description);
        this.writer.addWriteAction(writeAction);
    }

    @Override
    public void performRemoveLink(String sender, String receiver) {
        this.writer.addWriteAction(WriteAction.createRemoveLink(this.client, sender, receiver));
    }

    @Override
    public List<Map<String, Object>> performGetLinks(String address, int flags) {
        try {
            this.logger.debug("get links for {}", (Object)address);
            return this.client.getLinks(address, flags);
        }
        catch (XmlRpcException ex) {
            this.logger.error("getLinks failed for {}", (Object)address, (Object)ex);
            return null;
        }
    }

    @Override
    public HmDevice findControllingDevice(Resource ogemaDevice) {
        for (ResourceList l : ogemaDevice.getReferencingResources(ResourceList.class)) {
            if (l.getParent() == null || !(l.getParent() instanceof HmDevice)) continue;
            return (HmDevice)l.getParent();
        }
        for (Resource ref : ogemaDevice.getLocationResource().getReferencingNodes(true)) {
            if (ref.getParent() != null && ref.getParent().getParent() instanceof HmDevice) {
                return (HmDevice)ref.getParent().getParent();
            }
            for (ResourceList l : ref.getReferencingResources(ResourceList.class)) {
                if (l.getParent() == null || !(l.getParent() instanceof HmDevice)) continue;
                return (HmDevice)l.getParent();
            }
        }
        return null;
    }

    @Override
    public HmDevice getToplevelDevice(HmDevice channel) {
        if (channel.getParent() != null && channel.getParent().getParent() instanceof HmDevice) {
            return (HmDevice)channel.getParent().getParent();
        }
        return channel;
    }

    @Override
    public HmDevice getChannel(HmDevice device, String channelAddress) {
        Objects.requireNonNull(device);
        Objects.requireNonNull(channelAddress);
        for (HmDevice channel : device.channels().getAllElements()) {
            if (!channelAddress.equalsIgnoreCase(channel.address().getValue())) continue;
            return channel;
        }
        return null;
    }

    @Override
    public void registerControlledResource(HmDevice channel, Resource ogemaDevice) {
        Objects.requireNonNull(channel);
        Objects.requireNonNull(ogemaDevice);
        for (Resource entry : channel.controlledResources().getAllElements()) {
            if (!entry.equalsLocation(ogemaDevice)) continue;
            return;
        }
        channel.controlledResources().create().activate(false);
        channel.controlledResources().add(ogemaDevice);
    }

    public void init() {
        try {
            String serverUrl = null;
            HmLogicInterface config = this.baseResource;
            String urlPattern = config.baseUrl().getValue();
            if (urlPattern == null || urlPattern.isEmpty()) {
                urlPattern = "http://%s:%d";
            }
            String alias = config.alias().getValue();
            String iface = config.networkInterface().getValue();
            boolean ifSet = config.networkInterface().isActive() || config.baseUrl().isActive();
            List<NetworkInterface> n = null;
            if (!ifSet) {
                n = HmConnection.getBestMatchingInterfaces(config.clientUrl().getValue());
                if (n == null) {
                    throw new IllegalArgumentException("Bad configuration: Network interface or base url not set and failed to determine interface automatically");
                }
                this.logger.debug("network interface selected for {}: {}", (Object)config.clientUrl().getValue(), n);
            }
            if (!ifSet || iface != null && !iface.isEmpty()) {
                NetworkInterface nif;
                List<NetworkInterface> nifs;
                if (n != null) {
                    nifs = n;
                } else {
                    NetworkInterface nif2 = NetworkInterface.getByName(iface);
                    if (nif2 == null) {
                        throw new IllegalStateException("no such network interface: " + iface);
                    }
                    nifs = Collections.singletonList(nif2);
                }
                Inet4Address i4address = null;
                Iterator<NetworkInterface> iterator = nifs.iterator();
                while (iterator.hasNext() && (i4address = HmConnection.getAddressFromInterface(nif = iterator.next())) == null) {
                }
                if (i4address == null) {
                    throw new IllegalArgumentException("could not determine IP address for interface " + iface);
                }
                this.logger.info("Selected IPv4 address for own network interface {}", (Object)i4address);
                String ipAddrString = i4address.getHostAddress();
                serverUrl = String.format(urlPattern, ipAddrString, config.port().getValue());
            } else {
                serverUrl = urlPattern + alias;
            }
            this.client = new HomeMaticClient(config.clientUrl().getValue());
            this.commandLine = new HomeMaticClientCli(this.client).register(this.ctx.getBundleContext(), config.getName());
            this.hm = new HomeMaticService(this.ctx.getBundleContext(), serverUrl, alias);
            config.installationMode().stateControl().create();
            config.installationMode().stateFeedback().create();
            config.installationMode().activate(true);
            config.installationMode().stateControl().addValueListener(this.installModeListener, true);
            config.installationMode().stateFeedback().addValueListener(this.installModeListener, false);
            Persistence persistence = new Persistence(this.appman, config);
            this.hm.setBackend((HmBackend)persistence);
            this.hm.addDeviceListener((DeviceListener)persistence);
            this.performInitThread();
        }
        catch (IOException ex) {
            this.logger.error("could not start HomeMatic driver for config {} (2)", (Object)this.baseResource.getPath());
            this.logger.debug("Exception details:", (Throwable)ex);
        }
    }

    protected void performInitThreadDelayed() {
        this.logger.info("Will retry init for config {} after " + this.reInitTryTime / 1000L + " seconds.", (Object)this.baseResource.getPath());
        this.appman.createTimer(this.reInitTryTime, new TimerListener(){

            public void timerElapsed(Timer timer) {
                timer.destroy();
                HmConnection.this.performInitThread();
            }
        });
        this.reInitTryTime *= 2L;
        if (this.reInitTryTime > 86400000L) {
            this.reInitTryTime = 86400000L;
        }
    }

    protected void performInitThread() {
        if (this.initThread == null || !this.initThread.isAlive()) {
            this.initThread = new Thread(this.initTask, "homematic-xmlrpc-init");
            this.initThread.start();
        }
    }

    protected void close() {
        block7: {
            HmLogicInterface config = this.baseResource;
            try {
                if (this.t != null) {
                    this.t.destroy();
                }
                if (this.appman != null) {
                    this.appman.getResourceAccess().removeResourceDemand(HmDevice.class, this.devResourceListener);
                }
                config.installationMode().stateControl().removeValueListener(this.installModeListener);
                config.installationMode().stateFeedback().removeValueListener(this.installModeListener);
                if (this.client != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (HmConnection.this.hm != null) {
                                HmConnection.this.hm.close();
                            }
                            if (HmConnection.this.commandLine != null) {
                                HmConnection.this.commandLine.unregister();
                            }
                        }
                    }).start();
                }
                if (this.initThread != null && this.initThread.isAlive()) {
                    this.initThread.interrupt();
                }
                this.writer.close();
                if (this.logger != null) {
                    this.logger.info("HomeMatic configuration removed: {}", (Object)config);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block7;
                this.logger.error("HomeMatic XmlRpc driver shutdown failed", (Throwable)e);
            }
        }
    }

    private static Inet4Address getAddressFromInterface(NetworkInterface nif) {
        Enumeration<InetAddress> addresses = nif.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress a = addresses.nextElement();
            if (!(a instanceof Inet4Address)) continue;
            return (Inet4Address)a;
        }
        return null;
    }

    private static List<NetworkInterface> getBestMatchingInterfaces(String clientUrl) throws SocketException {
        if (HmConnection.isOwnLoopbackAddress(clientUrl)) {
            return Collections.singletonList(NetworkInterface.getByName("lo"));
        }
        String targetAddress = clientUrl;
        try {
            targetAddress = new URL(clientUrl).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        TreeMap<Integer, ArrayList<NetworkInterface>> matches = new TreeMap<Integer, ArrayList<NetworkInterface>>();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            int cnt = -1;
            while (ee.hasMoreElements()) {
                int level;
                InetAddress i = ee.nextElement();
                if (!(i instanceof Inet4Address) && !(i instanceof Inet6Address) || (level = HmConnection.getAgreementLevel(i.getHostAddress(), targetAddress)) <= cnt) continue;
                cnt = level;
            }
            if (cnt < 0) continue;
            ArrayList<NetworkInterface> ifs = (ArrayList<NetworkInterface>)matches.get(cnt);
            if (ifs == null) {
                ifs = new ArrayList<NetworkInterface>();
                matches.put(cnt, ifs);
            }
            ifs.add(n);
        }
        Logger logger = LoggerFactory.getLogger(HomeMaticDriver.class);
        if (matches.isEmpty()) {
            logger.error("No network interfaces found, cannot start driver");
            return null;
        }
        Iterator it = matches.descendingMap().values().iterator();
        ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
        while (it.hasNext()) {
            list.addAll((Collection)it.next());
        }
        return list;
    }

    private static int getAgreementLevel(String address, String targetAddress) {
        int sz = Math.min(address.length(), targetAddress.length());
        for (int i = 0; i < sz; ++i) {
            if (address.charAt(i) == targetAddress.charAt(i)) continue;
            return i;
        }
        return sz;
    }

    private static boolean isOwnLoopbackAddress(String clientUrl) {
        return clientUrl.contains("localhost") || clientUrl.contains("127.0.0.1") || clientUrl.contains("0:0:0:0:0:0:0:1") || clientUrl.contains("::1");
    }
}

