/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xmlrpc.XmlRpcException;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.resourcemanager.ResourceDemandListener;
import org.ogema.drivers.homematic.xmlrpc.hl.DeletionListener;
import org.ogema.drivers.homematic.xmlrpc.hl.HmConnection;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandler;
import org.ogema.drivers.homematic.xmlrpc.hl.api.DeviceHandlerFactory;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmLogicInterface;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmEvent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Application.class})
public class HomeMaticDriver
implements Application {
    private ApplicationManager appman;
    private EventAdmin eventAdmin;
    private ComponentContext ctx;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<HmLogicInterface, HmConnection> connections = new HashMap<HmLogicInterface, HmConnection>();
    private final SortedSet<HandlerRegistration> handlerFactories = new TreeSet<HandlerRegistration>();
    private final Map<String, Class<? extends DeviceHandler>> acceptedDevices = new HashMap<String, Class<? extends DeviceHandler>>();
    final ResourceDemandListener<HmLogicInterface> configListener = new ResourceDemandListener<HmLogicInterface>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceAvailable(HmLogicInterface t) {
            ArrayList<DeviceHandlerFactory> l = new ArrayList<DeviceHandlerFactory>(HomeMaticDriver.this.handlerFactories.size());
            SortedSet sortedSet = HomeMaticDriver.this.handlerFactories;
            synchronized (sortedSet) {
                for (HandlerRegistration reg : HomeMaticDriver.this.handlerFactories) {
                    l.add(reg.fac);
                }
            }
            HmConnection conn = new HmConnection(l, HomeMaticDriver.this.appman, HomeMaticDriver.this.eventAdmin, HomeMaticDriver.this.ctx, HomeMaticDriver.this.logger, HomeMaticDriver.this, t);
            HomeMaticDriver.this.connections.put(t, conn);
            conn.init();
        }

        public void resourceUnavailable(HmLogicInterface t) {
            ((HmConnection)HomeMaticDriver.this.connections.remove(t)).close();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void addHandlerFactory(DeviceHandlerFactory fac, Map<String, Object> serviceProperties) {
        int ranking = 1;
        if (serviceProperties.containsKey("service.ranking")) {
            ranking = (Integer)serviceProperties.get("service.ranking");
        }
        this.logger.info("adding handler factory {}, rank {}", (Object)fac, (Object)ranking);
        SortedSet<HandlerRegistration> sortedSet = this.handlerFactories;
        synchronized (sortedSet) {
            this.handlerFactories.add(new HandlerRegistration(fac, ranking));
        }
    }

    protected void removeHandlerFactory(DeviceHandlerFactory fac, Map<String, Object> serviceProperties) {
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.ctx = ctx;
    }

    public void start(ApplicationManager am) {
        this.appman = am;
        this.logger = am.getLogger();
        final Timer t = this.appman.createTimer(2000L);
        t.addListener(new TimerListener(){

            public void timerElapsed(Timer timer) {
                HomeMaticDriver.this.logger.info("HomeMatic driver ready, configuration pending");
                HomeMaticDriver.this.appman.getResourceAccess().addResourceDemand(HmLogicInterface.class, HomeMaticDriver.this.configListener);
                t.destroy();
            }
        });
    }

    public void stop(Application.AppStopReason asr) {
        if (this.appman != null) {
            this.appman.getResourceAccess().removeResourceDemand(HmLogicInterface.class, this.configListener);
        }
        Iterator<HmConnection> it = this.connections.values().iterator();
        while (it.hasNext()) {
            HmConnection conn = it.next();
            it.remove();
            conn.close();
        }
    }

    protected void pollParameters(HmConnection connection) {
        for (HmDevice dev : connection.baseResource.devices().getAllElements()) {
            for (HmDevice sub : dev.channels().getAllElements()) {
                this.setupDevice(sub);
            }
        }
    }

    protected HmConnection findConnection(HmDevice dev) {
        HmDevice p = dev;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        if (!(p instanceof HmLogicInterface)) {
            throw new IllegalStateException("HmDevice in wrong place: " + dev.getPath());
        }
        return this.connections.get((HmLogicInterface)((Object)p));
    }

    public void setupDevice(HmDevice dev) {
        String address = dev.address().getValue();
        if (this.acceptedDevices.containsKey(address)) {
            this.logger.debug("device {} already controlled by handler type {}", (Object)address, this.acceptedDevices.get(address));
            return;
        }
        HmConnection conn = this.findConnection(dev);
        if (conn == null) {
            this.logger.warn("no connection for device {}", (Object)dev.getPath());
            return;
        }
        try {
            DeviceDescription channelDesc = conn.client.getDeviceDescription(address);
            if (channelDesc.isDevice()) {
                dev.addStructureListener(new DeletionListener(address, conn.client, true, this.logger));
            }
            for (DeviceHandler h : conn.handlers) {
                if (!h.accept(channelDesc)) continue;
                this.logger.debug("handler available for {}: {}", (Object)address, (Object)h.getClass().getCanonicalName());
                HashMap paramSets = new HashMap();
                for (String set : dev.paramsets().getValues()) {
                    this.logger.trace("requesting paramset {} of device {}", (Object)set, (Object)address);
                    paramSets.put(set, conn.client.getParamsetDescription(address, set));
                }
                HmDevice masterDevice = channelDesc.isDevice() ? dev : (HmDevice)dev.getParent().getParent();
                h.setup(masterDevice, channelDesc, paramSets);
                this.acceptedDevices.put(address, h.getClass().asSubclass(DeviceHandler.class));
                break;
            }
        }
        catch (XmlRpcException ex) {
            this.logger.error("failed to configure value resources for device " + dev.getPath() + " address:" + address, (Throwable)ex);
        }
    }

    public void storeEvent(HmEvent e, SingleValueResource res) {
        this.logger.debug("storing event data for {}@{} to {}", new Object[]{e.getValueKey(), e.getAddress(), res.getPath()});
        if (res instanceof FloatResource) {
            ((FloatResource)res).setValue(e.getValueFloat());
        } else if (res instanceof IntegerResource) {
            ((IntegerResource)res).setValue(e.getValueInt());
        } else if (res instanceof StringResource) {
            ((StringResource)res).setValue(e.getValueString());
        } else if (res instanceof BooleanResource) {
            ((BooleanResource)res).setValue(e.getValueBoolean());
        } else {
            this.logger.warn("HomeMatic parameter resource is of unsupported type: {}", (Object)res.getResourceType());
        }
    }

    @Reference
    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    private static class HandlerRegistration
    implements Comparable<HandlerRegistration> {
        DeviceHandlerFactory fac;
        int ranking;

        public HandlerRegistration(DeviceHandlerFactory fac, int ranking) {
            this.fac = fac;
            this.ranking = ranking;
        }

        @Override
        public int compareTo(HandlerRegistration o) {
            int rankCompare = Integer.compare(this.ranking, o.ranking);
            return rankCompare == 0 ? o.fac.getClass().getCanonicalName().compareTo(this.fac.getClass().getCanonicalName()) : -rankCompare;
        }

        public boolean equals(Object obj) {
            return obj instanceof HandlerRegistration && this.fac.getClass() == ((HandlerRegistration)obj).fac.getClass();
        }

        public int hashCode() {
            return Objects.hashCode(this.fac);
        }

        public String toString() {
            return String.format("%d: %s", this.ranking, this.fac.getClass().getCanonicalName());
        }
    }
}

