/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.drivers.homematic.xmlrpc.hl;

import java.util.ArrayList;
import java.util.List;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.array.StringArrayResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmDevice;
import org.ogema.drivers.homematic.xmlrpc.hl.types.HmLogicInterface;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceDescription;
import org.ogema.drivers.homematic.xmlrpc.ll.api.DeviceListener;
import org.ogema.drivers.homematic.xmlrpc.ll.api.HmBackend;
import org.ogema.drivers.homematic.xmlrpc.ll.xmlrpc.DeviceDescriptionXmlRpc;
import org.slf4j.Logger;

class Persistence
implements HmBackend,
DeviceListener {
    private final ApplicationManager appman;
    private final HmLogicInterface hm;
    private final Logger logger;

    public Persistence(ApplicationManager appman, HmLogicInterface hm) {
        this.appman = appman;
        this.hm = hm;
        this.logger = appman.getLogger();
    }

    public List<DeviceDescription> getKnownDevices(String interfaceId) {
        ArrayList<DeviceDescription> rval = new ArrayList<DeviceDescription>();
        for (HmDevice dev : this.hm.devices().getAllElements()) {
            DeviceDescriptionXmlRpc dd = new DeviceDescriptionXmlRpc(dev.address().getValue(), dev.version().getValue());
            rval.add((DeviceDescription)dd);
            for (HmDevice c : dev.channels().getAllElements()) {
                rval.add((DeviceDescription)new DeviceDescriptionXmlRpc(c.address().getValue(), c.version().getValue()));
            }
        }
        this.logger.debug("return {} known devices", (Object)rval.size());
        return rval;
    }

    private static String createResourceName(String type, String address) {
        return ("HM_" + type + "_" + address).replaceAll("[^\\p{javaJavaIdentifierPart}]", "_");
    }

    private void storeCommonData(HmDevice dev, DeviceDescription desc) {
        ((StringResource)dev.type().create()).setValue(desc.getType());
        ((StringResource)dev.address().create()).setValue(desc.getAddress());
        ((IntegerResource)dev.version().create()).setValue(desc.getVersion());
        ((StringArrayResource)dev.paramsets().create()).setValues(desc.getParamsets());
    }

    private void storeDeviceData(HmDevice dev, DeviceDescription desc) {
        this.storeCommonData(dev, desc);
        ((StringArrayResource)dev.children().create()).setValues(desc.getChildren());
    }

    private void storeChannelData(HmDevice dev, DeviceDescription desc) {
        this.storeCommonData(dev, desc);
    }

    public void deviceAdded(String interfaceId, List<DeviceDescription> descriptions) {
        for (DeviceDescription dd : descriptions) {
            String deviceResName = Persistence.createResourceName(dd.getType(), dd.getAddress());
            if (dd.isDevice()) {
                HmDevice res = (HmDevice)this.hm.devices().addDecorator(deviceResName, HmDevice.class);
                this.logger.debug("new device: {}", (Object)res.getPath());
                this.storeDeviceData(res, dd);
                res.activate(true);
                continue;
            }
            String parentResName = Persistence.createResourceName(dd.getParentType(), dd.getParent());
            HmDevice parent = (HmDevice)this.hm.devices().getSubResource(parentResName);
            if (parent == null) {
                this.logger.warn("channel added for unknown parent device {}", (Object)parentResName);
                continue;
            }
            HmDevice channel = (HmDevice)parent.channels().addDecorator(deviceResName, HmDevice.class);
            this.logger.debug("new channel: {}", (Object)channel.getPath());
            this.storeChannelData(channel, dd);
            channel.activate(true);
        }
    }

    public void devicesDeleted(String interfaceId, List<String> addresses) {
        this.logger.warn("unimplemented callback: devicesDeleted({}, {})", (Object)interfaceId, addresses);
    }

    public void deviceUpdated(String interfaceId, String address, int hint) {
        this.logger.warn("unimplemented callback: deviceUpdated({}, {}, {})", new Object[]{interfaceId, address, hint});
    }

    public void deviceReplaced(String interfaceId, String oldDeviceAddress, String newDeviceAddress) {
        this.logger.warn("unimplemented callback: deviceUpdated({}, {}, {})", new Object[]{interfaceId, oldDeviceAddress, newDeviceAddress});
    }

    public void deviceReadded(String interfaceId, List<String> addresses) {
        this.logger.warn("unimplemented callback: deviceReadded({}, {})", (Object)interfaceId, addresses);
    }
}

